#include "parse_keys.h"

#include <library/cpp/tvmauth/src/parser.h>
#include <library/cpp/tvmauth/src/utils.h>
#include <library/cpp/tvmauth/src/protos/tvm_keys.pb.h>

#include <util/datetime/base.h>
#include <util/generic/yexception.h>
#include <util/stream/str.h>

namespace NPassport::NTvmknife {
    TString ParseKeys(const TString keys) {
        tvm_keys::Keys protoKeys;
        Y_ENSURE(protoKeys.ParseFromString(NTvmAuth::TParserTvmKeys::ParseStrV1(keys)),
                 "Protobuf is malformed");

        TStringStream res;

        auto printKey = [&](int idx, const auto& k) {
            res << "#" << idx
                << " id=" << k.gen().id()
                << " created_at=" << TInstant::Seconds(k.gen().createdtime())
                << " body_base64url=" << NTvmAuth::NUtils::Bin2base64url(k.gen().body())
                << Endl;
        };

        res << "TVM keys:" << Endl;
        for (int idx = 0; idx < protoKeys.tvm_size(); ++idx) {
            printKey(idx, protoKeys.tvm(idx));
        }
        res << Endl;

        auto printBb = [&](NTvmAuth::EBlackboxEnv env) {
            res << "Blackbox keys (" << env << "):" << Endl;
            for (int idx = 0; idx < protoKeys.bb_size(); ++idx) {
                const tvm_keys::BbKey& k = protoKeys.bb(idx);

                if (k.env() == tvm_keys::BbEnvType(env)) {
                    printKey(idx, k);
                }
            }
            res << Endl;
        };

        printBb(NTvmAuth::EBlackboxEnv::Prod);
        printBb(NTvmAuth::EBlackboxEnv::Test);
        printBb(NTvmAuth::EBlackboxEnv::ProdYateam);
        printBb(NTvmAuth::EBlackboxEnv::TestYateam);
        printBb(NTvmAuth::EBlackboxEnv::Stress);

        return res.Str();
    }
}
