#include "ssh_utils.h"

#include <library/cpp/tvmknife/output.h>

#include <util/stream/str.h>
#include <util/system/shellcommand.h>
#include <util/system/user.h>

namespace NPassport::NTvmknife {
    static TString GetLoginFromSshAgent() {
        TStringStream out;
        TShellCommand cmd("ssh-add -l | head -n1 | cut -d' ' -f3 | cut -d/ -f3",
                          TShellCommandOptions().SetOutputStream(&out));
        cmd.Run();

        Y_ENSURE(cmd.GetExitCode() && *cmd.GetExitCode() == 0);
        Y_ENSURE(!cmd.GetError());

        return out.Str();
    }

    TString TSshUtils::GetLogin() {
        try {
            TString login = GetUsername();

            try {
                if (!login || login == "root") {
                    login = GetLoginFromSshAgent();
                }
            } catch (...) {
            }

            Y_ENSURE(login);
            ::NTvmknife::NOutput::Out() << "Detected login: " << login << Endl;
            return login;
        } catch (const std::exception&) {
            ythrow yexception() << "Failed to determine login. Please use '-l' option";
        }
    }
}
