#pragma once

#include <util/generic/yexception.h>

#ifdef _unix_
    #include <termios.h>
#endif

namespace NPassport::NTvmknife {
#ifdef _unix_
    // https://stackoverflow.com/questions/6856635/hide-password-input-on-terminal
    class TTerminalAttrs {
    public:
        struct TTermiosEx: public yexception {
        };

    public:
        TTerminalAttrs() {
            /* Fetching current terminal state and fail if we can't. */
            int code = tcgetattr(STDERR_FILENO, &OldAttrs_);
            Y_ENSURE_EX(code == 0, TTermiosEx() << code);
        }
        ~TTerminalAttrs() {
            /* Restore terminal. */
            (void)tcsetattr(STDERR_FILENO, TCSAFLUSH, &OldAttrs_);
        }

        const termios& GetOldAttrs() const {
            return OldAttrs_;
        }

        static void TrySetNewAttrs(const termios& newAttrs) {
            /* Setting new terminal state and fail if we can't. */
            int code = tcsetattr(STDERR_FILENO, TCSAFLUSH, &newAttrs);
            Y_ENSURE_EX(code == 0, TTermiosEx() << code);
        }

    private:
        termios OldAttrs_{};
    };
#endif // _unix_
}
