#include "tvm_proxy.h"

#include "cache.h"
#include "get_ticket.h"
#include "ssh_utils.h"
#include "tvm_client.h"

#include <library/cpp/tvmknife/cache.h>
#include <library/cpp/tvmknife/simple_tvm_client.h>

#include <util/stream/output.h>
#include <util/string/cast.h>

namespace NPassport::NTvmknife {
    TString TTvmProxy::PublicKeys() {
        TString res = TCache::Get().GetPublicKeys();
        if (res) {
            return res;
        }

        res = TTvmClient::PublicKeys();
        if (res) {
            TCache::Get().SetPublicKeys(res);
        }
        return res;
    }

    TString TTvmProxy::ClientCred(const ui32 src, const ui32 dst, TStringBuf secret) {
        TString res = ::NTvmknife::TCache::Get().GetSrvTicket(src, dst);

        if (res.empty()) {
            res = TServiceTicket::GetTicketViaClientCred(src, dst, secret);
            ::NTvmknife::TCache::Get().SetSrvTicket(res, src, dst);
        }

        if (!res.EndsWith("\n")) {
            res.push_back('\n');
        }

        return res;
    }

    TString TTvmProxy::Sshkey(const ui32 src,
                              const ui32 dst,
                              TString login,
                              const TString& privateKey) {
        if (!login) {
            login = TSshUtils::GetLogin();
        }

        ::NTvmknife::TSimpleTvmClient::TSshArgs args;
        args.Src = src;
        args.Dst = dst;
        args.Login = login;

        TString res = privateKey
                          ? ::NTvmknife::TSimpleTvmClient::GetServiceTicketWithSshPrivateKey(
                                args, privateKey)
                          : ::NTvmknife::TSimpleTvmClient::GetServiceTicketWithSshAgent(
                                args);

        if (!res.EndsWith("\n")) {
            res.push_back('\n');
        }

        return res;
    }
}
