#include "unittest.h"

#include <passport/infra/libs/cpp/tvm/signer/signer.h>

#include <library/cpp/tvmauth/unittest.h>
#include <library/cpp/tvmauth/src/utils.h>

#include <util/stream/str.h>

namespace NPassport::NTvmknife {
    using namespace NTvmAuth;

    // These are the test keys, unfit for production.

    static const TString PRIVATE_PROD =
        "MIICUwKBgG-8ZUf8zYfyrHG_3jJoNhRNZtGcnW6Ihhzn0ohCV8WKYw-FJLvHa2pRrb6EjnkmIg"
        "jRfKboY2TAuHJzXG1YKGlW4h1Kdu-21uu3jB4MwsepPA04XqoCxUoYpPViHzJ_6pv4NKaJyC8V"
        "zviYFCb_qABjWJCx_fdhfznvwKWEoFYdAkEAqAx2xBrj46eFBQVlJUhWpmGt2lMBenVBzBZyr3"
        "7diLFu0lJWP1iw_O9scMlg1EhVeEZ7ThoYJxw2za2wtvJ42wJBAKo3BbC2sNRyit23n8A54gNR"
        "CA8JFrAYSj8YYZnkVE1DiO71VgUnX4WVqQiCg8Ww3kFYlPkb-UcKIeQlX7ZgAmcCQBbqfprF7C"
        "YY1UGHk-Sig1fHm56G9s_P5D8D4UFXBsgRzdWvhGFD2xkgrd2Y-dPtozxtBFfSh4-WBQM9KcRk"
        "JnwCQBVG4LYW1hqOUVu28_gHPEBqIQHhItYDCUfjDDM8iomocR3eqsCk6_CytSEQUHi2G8grEp"
        "8jfyjhRDyEq_bMAE0CQBUBjtiDXHx08KCgrKSpCtTMNbtKYC9OqDmCzlXv27EWLdpKSsfrFh-d"
        "7Y4ZLBqJCq8Iz2nDQwTjhtm1thbeTxsCQDM0f9paa8Q8gwNYkUYe0DDtzL9h7Eg5rC_ecrW81M"
        "UcWLSZuzNt_ZO6r4Aya3CNTM79km4bnBn1NJedwVSTDrYCQDnAVWh2oObpjCcWXUBWAQmJVtfz"
        "4ldKyT6Oa0vkY52wOYR_GG2jLgkg832nyAWVGD-HDEiMDzoT7lIyC-8f_q4";
    static const TString PRIVATE_TEST =
        "MIICVAKBgQCFM28TpJ13_6zbde_4q_CZVr67ZwlrEHdTAJ5eZoAK72rw7SngWB84ufwJOwx5S8"
        "7gOmBPFte-RcSxSqTdoZM_pfjO5bVEnfDdQbyUYSuLeln31nwv9cD8qAG3kjdmG9Y8oLWSUPMB"
        "qFx3CUFF4jIrd3hTcspcLCRY9YMwEeCQnQJBAKV2lHRBYjFkrP0YKjh2ORfMWa_ZVsyK-9ZJzV"
        "f-SZdnmQNGpL0cKcf3lUOXeMxOTCC3HfwChyZU91Cv5GdVmwMCQQDOFa6pInktP9QbA1vnZgl-"
        "PLzAtJBrYm1JLxNEf2-yq1INmkXXjk7-Zy3mHBph3AXkU2J1fQt8YhMQ020hVIPfAkB4W6hR7P"
        "H0YVgJhE6Hnj3U_8bEmdvPD7URGtvdkqNM-cpR6WCHayt2WrRaCRslVT0344sTHa3kyyPyt2rF"
        "rCq8AkAZwrXVJE8lp_qDYGt87MEvx5eYFpINbE2pJeJoj-32VWpBs0i68cnfzOW8w4NMO4C8im"
        "xOr6FvjEJiGm2kKpB8AkAUrtKOiCxGLJWfowVHDsci-Ys1-yrZkV96yTmq_8ky7PMgaNSXo4U4"
        "_vKocu8ZicmEFuO_gFDkyp7qFfyM6rNgAkBOjawH30QJSX34KKqyNDcCia9GyNyai-67TIS7DV"
        "vEw_uKNPm6vNzlaIGI_kNo0sHNCy0QtQBKo2jzsC230BVdAkA8m8iZhL-98cA9VatBWTKV9VCM"
        "AjlnqtJuxDC9B-22ybhoza_rWnjWyvE0oJFzifFjeT1Gw6gGpN7_EDBRBHVE";
    static const TString PRIVATE_PROD_TEAM =
        "MIICVAKBgQCS7MVx3lMm7uVhZh7aFAsV9RYgiP3UG9BAtr9OGWfhi0YI7yAbUomomb5iWYk5ZA"
        "bQHsf_lFWHFTFX0qmYWewNWTNQUo6wIFpgZdzXbE9WKhrBSUDCnmqndBC1nLH-x73tgigvO4uv"
        "jpSQtwueQiun4mjjpDNiL9AerjlZObwxDQJBAN8g42JCDRQL-nU-Dgumi2A6KfCWHYZ9crwWeD"
        "JInZo00yy8t165SW_NQ6My3qGJPhX9s_-3eohQL3qGBwK5xRMCQQCoke0IM2NIbwEHUSV3L_85"
        "7YkjFSO7ARtLsc78k0D3357JHroLRP2LfTY2HwZHxI3BsDmcLMx-n9u5dJOniJVfAkAYgrnGTP"
        "kUziiJ6lLZcKHKXmqpWdmDdxN6YzSAICh6p2HygGNXkMhsODRB-v12ZdUtVRxOpwfG6lssJC17"
        "-M6rAkAVEj2hBmxpDeAg6iSu5f_nPbEkYqR3YCNpdjnfkmge-_PZI9dBaJ-xb6bGw-DI-JG4Ng"
        "czhZmP0_t3LpJ08RKsAkAb5BxsSEGigX9Op8HBdNFsB0U-EsOwz65Xgs8GSROzRppll5br1ykt"
        "-ah0ZlvUMSfCv7Z_9u9RCgXvUMDgVziiAkBilejZzAYup1jQyEw1O9fNzQLLL44fiBI67EvCSj"
        "s0UTW4j2MFUzd5sF7y24eYxERuRjaZLFiG6qbNOqaYR4aYAkB6nsqmxdz2BNCJWeuk7TmNjc4a"
        "76qHc8mIJi2HGmvnjERyPCRwg9s18k3uls0LMp01qZx3Ky9OyVXt0Sfw9sjI";
    static const TString PRIVATE_TEST_TEAM =
        "MIICUwKBgFMcbEpl9ukVR6AO_R6sMyiU11I8b8MBSUCEC15iKsrVO8v_m47_TRRjWPYtQ9eZ7o"
        "1ocNJHaGUU7qqInFqtFaVnIceP6NmCsXhjs3MLrWPS8IRAy4Zf4FKmGOx3N9O2vemjUygZ9vUi"
        "SkULdVrecinRaT8JQ5RG4bUMY04XGIwFAkEAhqoUENwvyMLST7AofTdCAd1fcb2H72qWmQy3ir"
        "_FsAR9fUUNslMln-WyBmy9eeMzNpjzejRgLzqtob9u931-YwJBAJ3-9a22nOM3OoA8L0z9210h"
        "5JwnMUi5X_pFHoshKY7gvgDI_wz3rj2CIltemG-HYLSt3Tnw8AOfqQJKZGm1xHcCQAXO9oT-aW"
        "pMS8QM6k7WzR_AguMY48KPVzOlb-SdbtxTPiVaYZ9oPoYrumcB170KjS4_fj-5aiTqrP4cPgyc"
        "DTgCQBO_3rW205xm51AHhemfu2ukPJOE5ikXK_9Io9FkJTHcF8AZH-Ge9cewREtr0w3w7BaVu6"
        "c-HgBz9SBJTI02uI8CQBDVQoIbhfkYWkn2BQ-m6EA7q-43sP3tUtMhlvFX-LYAj6-oobZKZLP8"
        "tkDNl688ZmbTHm9GjAXnVbQ37d7vr8wCQEmwF8MCrJ1cXQ6Eb9bhaWFQ-ivfftXjqC4-1SRjPf"
        "dwYPwWFGLpqv256ADkeiD2noYKCCbmqvFFJ96qtKuW_ekCQGn6iKuVXJd9n-hhSIkTxW28VPnf"
        "hDA3H8HWDH_RTpRMlLc8IytkIo2cjNuWO-uAY2UZp98WDKCzFdchG0213v0";
    static const TString PRIVATE_STRESS =
        "MIICUwKBgGpCkW-NR3li8GlRvqpq2YZGSIgm_PTyDI2Zwfw69grsBmPpVFW48Vw7xoMN35zcro"
        "jEpialB_uQzlpLYOvsMl634CRIuj-n1QE3-gaZTTTE8mg-AR4mcxnTKThPnRQpbuOlYAnriwia"
        "sWiQEMbGjq_HmWioYYxFo9USlklQn4-9AkEAyZBz_sQPZW5HSxGmbspszDzYpbitf7R_5E5ZM1"
        "zYlq_5_uElqNHh8AylODpshBAi9JiMi0KTMeUy716_hpaD6wJBAIb1ERyyO1sZ-eS7pJE5kfyO"
        "yPkNWClgFrsTQ5q7c4FfG1IqS5z2HqYxG7TvN_3QqonTL1IhiIFCLPJo5BRI2PcCQEhzOLNxP1"
        "z1o9GbuclKvWpCZP9j1Z-Y7slbLbu2MnvHAmEY0vdTmsWbSmMMxi4OgXm-o09Sj8xVELPUd6lH"
        "6cACQBDeoiOWR2tjPzyXdJInMj-R2R8hqwUsAtdiaHNXbnAr42pFSXOew9TGI3ad5v-6FVE6Ze"
        "pEMRAoRZ5NHIKJGx8CQBkyDn_YgeytyOliNM3ZTZmHmxS3Fa_2j_yJyyZrmxLV_z_cJLUaPD4B"
        "lKcHTZCCBF6TEZFoUmY8pl3r1_DS0H0CQFvrLWyeai0S-pgekBNdAQyiruBU5fachNxUnJRb3C"
        "zPv0iWKw9OmDm4Mp7zBQAskf02AyrLPaveQqT1w1vKE-gCQCgBq_XA-IqujM9UjF_PIa5z6JgB"
        "GrsXREeOFcDggfXPxbSxXj7tQdTCKvGR272l0b21MD7Q6njXhoeezWA_rh4";
    static const TString PRIVATE_TVM =
        "MIICVQKBgQC4a4oW39xKYw0EtrAkB2s6BYDdJwWxPXnrJ5xU380BC129oJyVPXp5lf2g6mhyo4LSyD"
        "6QoJ-NJR65-ZOprx-TnXnciOnAsxPjfhhad5wKtDQycjHtH4bSEQ__wm09LpXL5HqMOubm11n8OnQQ"
        "toEf9-K3THvy_0xkSzFow1C2zQJBANJufhSF9qTZnFlA73M3Mofzhf2AqVqe2L2uN5S9mQyhx6o8zz"
        "Bm7pGiMiIea9dmOhLyS_BihHkmq4dIw40a25MCQQDgWxGhgsLCiR8R7qd7ixC669xRXyimJz5QYpWK"
        "eXhZH4fUjLIbgRRQVhKezMunkAs81yPSVwFyzla8kFTYA2AfAkEAigT7h01LzA_rL9xSyd_I17dSZk"
        "Visp7vdyxnrjD1iZqX2IPF9RTrEi7sboCaaP1hS2-G1vs1he3QNdcoTyEGegJAHAtiNDBYWFEj4j3U"
        "73FiF117iivlFMTnygxSsU8vCyPw-pGWQ3AiigrCU9mZdPIBZ5rkekrgLlnK15IKmwBsBAJAGk3Pwp"
        "C-1Jsziygd7mbmUP5wv7AVK1PbF7XG8pezIZQ49UeZ5gzd0jRGREPNeuzHQl5JfgxQjyTVcOkYcaNb"
        "cgJATBRJcYoDdz5Y4Wq3Aui8cu8eMFe7iL1Q63twjW47OBjkmLKYYckGryfPHr9IISSazZHAnphq3T"
        "kCDZWRYhoMDQJASwsbzFCz7PcNqmQzPBi3foWh7PsYGgpwYINuBS4VnWhIlSaUz3y4HYIyBywVYkIf"
        "HfatfRtoT3pNrcosXH0BYg";

    TString TUnittest::GetServiceTicket(ui64 src,
                                        ui64 dst,
                                        const std::vector<TString>& scopes,
                                        NTvmAuth::TUid issuerUid) {
        NPassport::NTicketSigner::TServiceSigner b;

        b.SetSides(src, dst);
        for (const TString& s : scopes) {
            b.AddScope(s);
        }
        if (issuerUid > 0) {
            b.SetIssuerUid(issuerUid);
        }

        NRw::TRwPrivateKey pk(NUtils::Base64url2bin(PRIVATE_TVM), 16);
        TStringStream ss;
        ss << b.SerializeV3(pk, std::numeric_limits<time_t>::max()) << Endl;
        return ss.Str();
    }

    TString TUnittest::GetUserTicket(ui64 defaultUid,
                                     const std::vector<ui64>& uids,
                                     const std::vector<TString>& scopes,
                                     const TString& env) {
        NPassport::NTicketSigner::TUserSigner b;
        b.SetEntryPoint(1234567890);

        for (ui64 u : uids) {
            b.AddUid(u);
        }
        if (defaultUid > 0) {
            b.AddUid(defaultUid);
        }
        b.SetDefaultUid(defaultUid);
        for (const TString& s : scopes) {
            b.AddScope(s);
        }

        std::unique_ptr<NRw::TRwPrivateKey> pk;
        if (env == "prod") {
            b.SetEnv(EBlackboxEnv::Prod);
            pk = std::make_unique<NRw::TRwPrivateKey>(NUtils::Base64url2bin(PRIVATE_PROD), 11);
        } else if (env == "test") {
            b.SetEnv(EBlackboxEnv::Test);
            pk = std::make_unique<NRw::TRwPrivateKey>(NUtils::Base64url2bin(PRIVATE_TEST), 13);
        } else if (env == "prod_yateam") {
            b.SetEnv(EBlackboxEnv::ProdYateam);
            pk = std::make_unique<NRw::TRwPrivateKey>(NUtils::Base64url2bin(PRIVATE_PROD_TEAM), 12);
        } else if (env == "test_yateam") {
            b.SetEnv(EBlackboxEnv::TestYateam);
            pk = std::make_unique<NRw::TRwPrivateKey>(NUtils::Base64url2bin(PRIVATE_TEST_TEAM), 14);
        } else if (env == "stress") {
            b.SetEnv(EBlackboxEnv::Stress);
            pk = std::make_unique<NRw::TRwPrivateKey>(NUtils::Base64url2bin(PRIVATE_STRESS), 15);
        } else {
            ythrow yexception() << "Supported env: prod, test, prod_yateam, test_yateam, stress";
        }

        TStringStream ss;
        ss << b.SerializeV3(*pk, std::numeric_limits<time_t>::max()) << Endl;
        return ss.Str();
    }

    TString TUnittest::GetPublicKeys() {
        TStringStream ss;
        ss << NTvmAuth::NUnittest::TVMKNIFE_PUBLIC_KEYS << Endl;
        return ss.Str();
    }
}
