LIBRARY()

OWNER(g:passport_infra)

PEERDIR(
    library/cpp/colorizer
    library/cpp/config
    library/cpp/getopt
    library/cpp/http/simple
    library/cpp/json
    library/cpp/ipv6_address
    library/cpp/oauth
    library/cpp/openssl/crypto
    library/cpp/tvmknife
    library/cpp/tvmauth
    library/cpp/tvmauth/client
    passport/infra/libs/cpp/tvm/signer
    passport/infra/tools/tvmknife/src/proto
    library/cpp/cgiparam
    library/cpp/string_utils/quote
    library/cpp/string_utils/url
)

SRCS(
    aliases.cpp
    blackbox_client.cpp
    blackbox_proxy.cpp
    cache.cpp
    get_ticket.cpp
    info.cpp
    menu.cpp
    oauth_clients.cpp
    parse_anyway.cpp
    parse_keys.cpp
    ssh_utils.cpp
    tvm_client.cpp
    tvm_proxy.cpp
    unittest.cpp
)

GENERATE_ENUM_SERIALIZATION(cache.h)

END()
