#include <passport/infra/tools/tvmknife/src/aliases.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NTvmknife;

Y_UNIT_TEST_SUITE(TvmKnifeAliases) {
    Y_UNIT_TEST_DECLARE(getValueForAlias);
    Y_UNIT_TEST_DECLARE(noAliasesFile);
}

class TestTAliases: public TAliases {
    Y_UNIT_TEST_FRIEND(TvmKnifeAliases, getValueForAlias);
    Y_UNIT_TEST_FRIEND(TvmKnifeAliases, noAliasesFile);
};

Y_UNIT_TEST_SUITE_IMPLEMENTATION(TvmKnifeAliases) {
    Y_UNIT_TEST(getValueForAlias) {
        TestTAliases aliases;
        aliases.ReadFromFile(ArcadiaSourceRoot() + "/passport/infra/tools/tvmknife/ut/aliases");

        UNIT_ASSERT_VALUES_EQUAL_C(
            aliases.ResolveAlias("section_1", "service_testing"),
            TMaybe<ui32>(111),
            "Should find existing alias");

        UNIT_ASSERT_VALUES_EQUAL_C(
            aliases.ResolveAlias("section_1", "service_production"),
            TMaybe<ui32>(222),
            "Should find existing alias");

        UNIT_ASSERT_VALUES_EQUAL_C(
            aliases.ResolveAlias("section_2", "service_testing"),
            TMaybe<ui32>(333),
            "Should return value for alias in provided section");

        UNIT_ASSERT_VALUES_EQUAL_C(
            aliases.ResolveAlias("section_1", "service_dev"),
            TMaybe<ui32>(),
            "Should return empty for unknown alias");

        UNIT_ASSERT_VALUES_EQUAL_C(
            aliases.ResolveAlias("section_3", "service_production"),
            TMaybe<ui32>(),
            "Should return empty for unknown section");

        UNIT_ASSERT_VALUES_EQUAL_C(
            aliases.ResolveAlias("section_1", "service_prestable"),
            TMaybe<ui32>(),
            "Should return empty for alias not in provided section");

        UNIT_ASSERT_VALUES_EQUAL_C(
            aliases.ResolveAlias("section_2", "service_not_a_number"),
            TMaybe<ui32>(),
            "Should ignore invalid alias");

        UNIT_ASSERT_VALUES_EQUAL_C(
            aliases.ResolveAlias("section_2", "service_number_too_big_number"),
            TMaybe<ui32>(),
            "Should ignore invalid alias");
    }

    Y_UNIT_TEST(noAliasesFile) {
        TestTAliases aliases;
        aliases.ReadFromFile(ArcadiaSourceRoot() + "/passport/infra/tools/tvmknife/ut/no_such_file");

        UNIT_ASSERT_VALUES_EQUAL_C(
            aliases.ResolveAlias("some_section", "some_alias"),
            TMaybe<ui32>(),
            "Should return empty if no aliases file exist");
    }
}
