#include "common.h"

#include <passport/infra/tools/tvmknife/src/blackbox_client.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NTvmknife;

Y_UNIT_TEST_SUITE(BbClient) {
    Y_UNIT_TEST(doOauth) {
        TPortManager pm;
        ui16 port = pm.GetPort(80);
        NMock::TMockServer server(port, []() { return new NMock::TBlackbox; });

        UNIT_ASSERT_VALUES_EQUAL(R"({"user_ticket":"user_ticket_1"})",
                                 TBbClient::DoRequest(TStringBuilder() << "localhost:" << port,
                                                      {"/blackbox?method=get_debug_user_ticket&format=json", "oauth_token=token_1"},
                                                      "service_ticket"));

        UNIT_ASSERT_EXCEPTION_CONTAINS(TBbClient::DoRequest("localhost:1",
                                                            {"/blackbox?method=get_debug_user_ticket&format=json", "oauth_token=token_1"},
                                                            "service_ticket"),
                                       yexception,
                                       "/blackbox?method=get_debug_user_ticket&format=json\n"
                                       "X-Ya-Service-Ticket: service_ticket");
    }
}
