#include <passport/infra/tools/tvmknife/src/cache.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/tvmauth/src/utils.h>

#include <util/system/fs.h>

using namespace NPassport::NTvmknife;

Y_UNIT_TEST_SUITE(TestCache) {
    TString GetKeys() {
        return ArcadiaSourceRoot() + "/passport/infra/tools/tvmknife/ut/keys/";
    }

    Y_UNIT_TEST(serializeUsrTickets) {
        std::set<TCache::TUsrTick> s;
        s.insert({"token_1", "", false, false, "ticket_body1", std::numeric_limits<time_t>::max()});
        s.insert({"token_2", "", false, false, "ticket_body2", std::numeric_limits<time_t>::max()});

        TString ser = TCache::SerializeUsrTickets(s);
        UNIT_ASSERT_STRINGS_EQUAL(
            "CicSB3Rva2VuXzEw__________9_Ogx0aWNrZXRfYm9keTFSAFgAYAAKJxIHdG9rZW5fMjD__________386DHRpY2tldF9ib2R5MlIAWABgAA",
            NTvmAuth::NUtils::Bin2base64url(ser));

        s = TCache::ParseUsrTickets(ser);
        UNIT_ASSERT_VALUES_EQUAL(2, s.size());

        UNIT_ASSERT_VALUES_EQUAL("token_1", s.begin()->Token);
        UNIT_ASSERT_STRINGS_EQUAL("ticket_body1", s.begin()->Body);
        UNIT_ASSERT_VALUES_EQUAL(std::numeric_limits<time_t>::max(), s.begin()->Ts);

        UNIT_ASSERT_VALUES_EQUAL("token_2", s.rbegin()->Token);
        UNIT_ASSERT_STRINGS_EQUAL("ticket_body2", s.rbegin()->Body);
        UNIT_ASSERT_VALUES_EQUAL(std::numeric_limits<time_t>::max(), s.rbegin()->Ts);
    }

    Y_UNIT_TEST(read) {
        TCache c;
        c.SetCacheDir(GetKeys());

        UNIT_ASSERT_STRINGS_EQUAL("kek public_keys lol", c.GetPublicKeys());
    }

    Y_UNIT_TEST(write) {
        TCache c;
        c.SetCacheDir("./");

        const TString pk = "new public keys";
        const TString tick = "new tick";

        UNIT_ASSERT(!NFs::Exists("./public_keys"));
        c.SetPublicKeys(pk);
        UNIT_ASSERT(NFs::Exists("./public_keys"));
        UNIT_ASSERT_STRINGS_EQUAL(pk, c.GetPublicKeys());
    }
}
