#pragma once

#include <library/cpp/cgiparam/cgiparam.h>
#include <library/cpp/testing/mock_server/server.h>

#include <util/string/builder.h>
#include <util/system/env.h>

namespace NMock {
    class TBlackbox: public TRequestReplier {
    public:
        static void Return404(const TReplyParams& params, TString response) {
            THttpResponse resp(HTTP_NOT_FOUND);
            resp.SetContent(response);
            resp.OutTo(params.Output);
        }

        static TString GetArg(const TCgiParameters& cgi, const TString& name) {
            auto it = cgi.find(name);
            return it == cgi.end() ? TString() : it->second;
        }

        bool DoReply(const TReplyParams& params) override {
            const TParsedHttpFull parsed(params.Input.FirstLine());
            TCgiParameters cgi(parsed.Cgi);
            cgi.ScanAdd(params.Input.ReadAll());

            if (parsed.Path != "/blackbox") {
                Return404(params, TStringBuilder() << "path is unknown: " << parsed.Path);
                return true;
            }

            const TString method = GetArg(cgi, "method");
            if (method.empty()) {
                Return404(params, TStringBuilder() << "missing method");
                return true;
            }

            if (method == "get_debug_user_ticket") {
                for (const TString arg : {"oauth_token"}) {
                    if (GetArg(cgi, arg).empty()) {
                        Return404(params, TStringBuilder() << "missing arg: " << arg);
                        return true;
                    }
                }

                THttpResponse resp(HTTP_OK);
                resp.SetContent(GetArg(cgi, "oauth_token") == "token_1"
                                    ? R"({"user_ticket":"user_ticket_1"})"
                                    : R"({"user_ticket":"user_ticket_2"})");
                resp.OutTo(params.Output);
                return true;
            }

            Return404(params, TStringBuilder() << "bad request");
            return true;
        }
    };
}

inline void SetTz() {
    SetEnv("TZ", "Europe/Moscow");
    tzset();
}
