#include "common.h"

#include <passport/infra/tools/tvmknife/src/info.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NTvmknife;

Y_UNIT_TEST_SUITE(TvmKnifeInfo) {
    Y_UNIT_TEST(getInfoFromTvmResponse) {
        TInfo::TTvmInfo t;

        t = TInfo::GetInfoFromTvmResponse(R"({"name":"Passport. Blackbox Prod","abc_service_id":null,"env_type":"production","modification_time":1456401357,"create_time":1455978612,"creator_uid":1120000000000048,"id":1})");
        UNIT_ASSERT_STRINGS_EQUAL("Passport. Blackbox Prod", t.Description);
        UNIT_ASSERT_VALUES_EQUAL(0, t.AbcId);

        t = TInfo::GetInfoFromTvmResponse(R"({"owners":[],"signature_type":"hmac","owner_groups":[],"name":"killer_ficha","secret_keys":{},"abc_service_id":14,"token_ttl":3600,"is_symmetric":false,"allowed_grant_types":[],"payload":"","env_type":"undefined","modification_time":1513687022,"allowed_uids":[],"create_time":1513687022,"client_secret":"xE5K6QB7tNC37dY_EL55Fg","old_client_secret":"","creator_uid":1120000000026887,"id":2000374})");
        UNIT_ASSERT_STRINGS_EQUAL("killer_ficha", t.Description);
        UNIT_ASSERT_VALUES_EQUAL(14, t.AbcId);

        t = TInfo::GetInfoFromTvmResponse(R"()");
        UNIT_ASSERT(!t.Description);
        UNIT_ASSERT_VALUES_EQUAL(0, t.AbcId);

        UNIT_ASSERT_EXCEPTION(TInfo::GetInfoFromTvmResponse(R"({"ow)"), yexception);
    }

    Y_UNIT_TEST(getInfoImpl) {
        SetTz();
        UNIT_ASSERT_STRINGS_EQUAL(
            R"(Client with id=100500 not found
)",
            TInfo::GetInfoImpl("100500", {}, {}));

        UNIT_ASSERT_STRINGS_EQUAL(
            R"(Client id (tvm id): 100500
Client description: Passport. Blackbox Prod
Client is not linked with ABC service
)",
            TInfo::GetInfoImpl("100500", {"Passport. Blackbox Prod", {}, {}, ""}, {}));

        UNIT_ASSERT_STRINGS_EQUAL(
            R"(Client id (tvm id): 100500
Client description: Passport. Blackbox Prod
ABC service: https://abc.yandex-team.ru/services/123/
Tvm secret in yav: https://kek.lol.ru
)",
            TInfo::GetInfoImpl("100500", {"Passport. Blackbox Prod", 123, {}, "https://kek.lol.ru"}, {.Yav = true}));
        UNIT_ASSERT_STRINGS_EQUAL(
            R"(Client id (tvm id): 100500
Client description: Passport. Blackbox Prod
ABC service: https://abc.yandex-team.ru/services/123/
)",
            TInfo::GetInfoImpl("100500", {"Passport. Blackbox Prod", 123, {}, "https://kek.lol.ru"}, {}));

        NColorizer::TColors c(true);

        UNIT_ASSERT_STRINGS_EQUAL(
            R"(Client id (tvm id): 100500 - deleted at: 1970-01-02T06:55:00+0300
Client description: Passport. Blackbox Prod
ABC service: https://abc.yandex-team.ru/services/123/
)",
            TInfo::GetInfoImpl("100500",
                               {"Passport. Blackbox Prod", 123, TInstant::Seconds(100500), ""},
                               {},
                               TInfo::EColored::False));
        UNIT_ASSERT_STRINGS_EQUAL(
            R"(Client id (tvm id): 100500 - deleted at: 1970-01-02T06:55:00+0300
Client description: Passport. Blackbox Prod
ABC service: https://abc.yandex-team.ru/services/123/
Tvm secret in yav: NULL
)",
            TInfo::GetInfoImpl("100500",
                               {"Passport. Blackbox Prod", 123, TInstant::Seconds(100500), ""},
                               {.Yav = true},
                               TInfo::EColored::False));
    }
}
