#include "common.h"

#include <passport/infra/tools/tvmknife/src/parse_anyway.h>
#include <passport/infra/tools/tvmknife/src/unittest.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NTvmknife;

Y_UNIT_TEST_SUITE(TvmKnifeParse) {
    Y_UNIT_TEST(ServiceV3) {
        SetTz();

        UNIT_ASSERT_STRINGS_EQUAL(R"(Version: 3
Expire time: 9223372036854775807 == 586524-01-19T11:01:48+0300 (ok)
Key id: 16
Sign: no sign
Integral check: Invalid ticket signature

Body
Src: 117
Dst: 118
Scope: qwe
Scope: wer
Issuer: <undefined>
)",
                                  TAnywayParser::ParseV3("3:serv:CBAQ__________9_Ig4IdRB2GgNxd2UaA3dlcg:"));

        UNIT_ASSERT_STRINGS_EQUAL(R"(Version: 3
Expire time: 9223372036854775807 == 586524-01-19T11:01:48+0300 (ok)
Key id: 16
Sign: ok
Integral check: OK

Body
Src: 117
Dst: 118
Scope: qwe
Scope: wer
Issuer: <undefined>
)",
                                  TAnywayParser::ParseV3("3:serv:CBAQ__________9_Ig4IdRB2GgNxd2UaA3dlcg:E12QQ29sQl4ChOlmfe_Csd8saBdMARZvZx8_-vE8C8wonHe0Z2RiPhKPiyCz3mucOM-6s1xRF9mKvU8u0zJe3RoKIZ27Gh9ho2ZjmHtAxvK2AAXZ7X5KvJUNcYivVuoQ3rtQxAt3KIy80SAbPtZeS0QOTdkz7SbAEnvUIJkMkS4",
                                                         TUnittest::GetPublicKeys()));
    }

    Y_UNIT_TEST(UserV3) {
        SetTz();

        UNIT_ASSERT_STRINGS_EQUAL(R"(Version: 3
Expire time: 9223372036854775807 == 586524-01-19T11:01:48+0300 (ok)
Key id: 11
Sign: no sign
Integral check: Invalid ticket signature

Body
Uid: 100500
Default uid: 100500
Scope: qwe
Scope: wer
Entry point: 1234567890
Env: prod
)",
                                  TAnywayParser::ParseV3("3:user:CAsQ__________9_GhwKBAiUkQYQlJEGGgNxd2UaA3dlciDShdjMBCgA:"));

        UNIT_ASSERT_STRINGS_EQUAL(R"(Version: 3
Expire time: 9223372036854775807 == 586524-01-19T11:01:48+0300 (ok)
Key id: 11
Sign: ok
Integral check: OK

Body
Uid: 100500
Default uid: 100500
Scope: qwe
Scope: wer
Entry point: 1234567890
Env: prod
)",
                                  TAnywayParser::ParseV3("3:user:CAsQ__________9_GhwKBAiUkQYQlJEGGgNxd2UaA3dlciDShdjMBCgA:A03JTwc1XjX4cQlWOcoc7fCQYwjgszsyDRSnwcfd_G2wOdIBFXIstG6Wwe46ve4OcOLlmYyuKSHAU0HmUVffG2fDbWnNmX5geBrnHEjy5YVXb3vtue_Huqgyaas4dI1-o7CfdfRClXz_CctcTkTQFQ-sAEnLDJIADUVBNeXqSKc",
                                                         TUnittest::GetPublicKeys()));
    }
}
