#include <passport/infra/tools/tvmknife/src/cache.h>
#include <passport/infra/tools/tvmknife/src/tvm_proxy.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/tvmauth/src/utils.h>
#include <library/cpp/tvmknife/cache.h>

#include <util/system/fs.h>

using namespace NPassport::NTvmknife;

Y_UNIT_TEST_SUITE(TestProxy) {
    TString GetKeys() {
        return ArcadiaSourceRoot() + "/passport/infra/tools/tvmknife/ut/keys/";
    }

    Y_UNIT_TEST(read) {
        TCache::Get().SetCacheDir(GetKeys());

        UNIT_ASSERT_STRINGS_EQUAL("kek public_keys lol", TTvmProxy::PublicKeys());

        NTvmknife::TCache::Get().SetSrvTicket("ticket_body2", 123, 456);
        NTvmknife::TCache::Get().SetSrvTicket("ticket_body", 123, 456, "vasya");

        UNIT_ASSERT_VALUES_EQUAL("ticket_body2\n", TTvmProxy::ClientCred(123, 456, ""));
        UNIT_ASSERT_VALUES_EQUAL("ticket_body\n", TTvmProxy::Sshkey(123, 456, "vasya", ""));
    }
}
