#include <passport/infra/tools/tvmknife/src/unittest.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/tvmauth/deprecated/service_context.h>
#include <library/cpp/tvmauth/deprecated/user_context.h>

using namespace NPassport::NTvmknife;

Y_UNIT_TEST_SUITE(TvmKnifeUnit) {
    Y_UNIT_TEST(publo) {
        UNIT_ASSERT_STRINGS_EQUAL("1:CpgCCpMCCAEQABqIAjCCAQQCggEAcLEXeH67FQESFUn4_7wnX7wN0PUrBoUsm3QQ4W5vC-qz6sXaEjSwnTV8w1o-z6X9KPLlhzMQvuS38NCNfK4uvJ4Zvfp3YsXJ25-rYtbnrYJHNvHohD-kPCCw_yZpMp21JdWigzQGuV7CtrxUhF-NNrsnUaJrE5-OpEWNt4X6nCItKIYeVcSK6XJUbEWbrNCRbvkSc4ak2ymFeMuHYJVjxh4eQbk7_ZPzodP0WvF6eUYrYeb42imVEOR8ofVLQWE5DVnb1z_TqZm4i1XkS7jMwZuBxBRw8DGdYei0lT_sAf7KST2jC0590NySB3vsBgWEVs1OdUUWA6r-Dvx9dsOQtSCVkQYQAAqZAgqUAggCEAAaiQIwggEFAoIBAQDhEBM5-6YsPWfogKtbluJoCX1WV2KdzOaQ0-OlRbBzeCzw-eQKu12c8WakHBbeCMd1I1TU64SDkDorWjXGIa_2xT6N3zzNAE50roTbPCcmeQrps26woTYfYIuqDdoxYKZNr0lvNLLW47vBr7EKqo1S4KSj7aXK_XYeEvUgIgf3nVIcNrio7VTnFmGGVQCepaL1Hi1gN4yIXjVZ06PBPZ-DxSRu6xOGbFrfKMJeMPs7KOyE-26Q3xOXdTIa1X-zYIucTd_bxUCL4BVbwW2AvbbFsaG7ISmVdGu0XUTmhXs1KrEfUVLRJhE4Dx99hAZXm1_HlYMUeJcMQ_oHOhV94ENFIJaRBhACCpYBCpEBCAMQABqGATCBgwKBgF9t2YJGAJkRRFq6fWhi3m1TFW1UOE0f6ZrfYhHAkpqGlKlh0QVfeTNPpeJhi75xXzCe6oReRUm-0DbqDNhTShC7uGUv1INYnRBQWH6E-5Fc5XrbDFSuGQw2EYjNfHy_HefHJXxQKAqPvxBDKMKkHgV58WtM6rC8jRi9sdX_ig2NIJeRBhABCpYBCpEBCAQQABqGATCBgwKBgGB4d6eLGUBv-Q6EPLehC4S-yuE2HB-_rJ7WkeYwyp-xIPolPrd-PQme2utHB4ZgpXHIu_OFksDe_0bPgZniNRSVRbl7W49DgS5Ya3kMfrYB4DnF5Fta5tn1oV6EwxYD4JONpFTenOJALPGTPawxXEfon_peiHOSBuQMu3_Vn-l1IJiRBhADCpcBCpIBCAUQABqHATCBhAKBgQCTJMKIfmfeZpaI7Q9rnsc29gdWawK7TnpVKRHws1iY7EUlYROeVcMdAwEqVM6f8BVCKLGgzQ7Gar_uuxfUGKwqEQzoppDraw4F75J464-7D5f6_oJQuGIBHZxqbMONtLjBCXRUhQW5szBLmTQ_R3qaJb5vf-h0APZfkYhq1cTttSCZkQYQBAqWAQqRAQgLEAAahgEwgYMCgYBvvGVH_M2H8qxxv94yaDYUTWbRnJ1uiIYc59KIQlfFimMPhSS7x2tqUa2-hI55JiII0Xym6GNkwLhyc1xtWChpVuIdSnbvttbrt4weDMLHqTwNOF6qAsVKGKT1Yh8yf-qb-DSmicgvFc74mBQm_6gAY1iQsf33YX8578ClhKBWHSCVkQYQAAqXAQqSAQgMEAAahwEwgYQCgYEAkuzFcd5TJu7lYWYe2hQLFfUWIIj91BvQQLa_Thln4YtGCO8gG1KJqJm-YlmJOWQG0B7H_5RVhxUxV9KpmFnsDVkzUFKOsCBaYGXc12xPVioawUlAwp5qp3QQtZyx_se97YIoLzuLr46UkLcLnkIrp-Jo46QzYi_QHq45WTm8MQ0glpEGEAIKlwEKkgEIDRAAGocBMIGEAoGBAIUzbxOknXf_rNt17_ir8JlWvrtnCWsQd1MAnl5mgArvavDtKeBYHzi5_Ak7DHlLzuA6YE8W175FxLFKpN2hkz-l-M7ltUSd8N1BvJRhK4t6WffWfC_1wPyoAbeSN2Yb1jygtZJQ8wGoXHcJQUXiMit3eFNyylwsJFj1gzAR4JCdIJeRBhABCpYBCpEBCA4QABqGATCBgwKBgFMcbEpl9ukVR6AO_R6sMyiU11I8b8MBSUCEC15iKsrVO8v_m47_TRRjWPYtQ9eZ7o1ocNJHaGUU7qqInFqtFaVnIceP6NmCsXhjs3MLrWPS8IRAy4Zf4FKmGOx3N9O2vemjUygZ9vUiSkULdVrecinRaT8JQ5RG4bUMY04XGIwFIJiRBhADCpYBCpEBCA8QABqGATCBgwKBgGpCkW-NR3li8GlRvqpq2YZGSIgm_PTyDI2Zwfw69grsBmPpVFW48Vw7xoMN35zcrojEpialB_uQzlpLYOvsMl634CRIuj-n1QE3-gaZTTTE8mg-AR4mcxnTKThPnRQpbuOlYAnriwiasWiQEMbGjq_HmWioYYxFo9USlklQn4-9IJmRBhAEEpUBCpIBCAYQABqHATCBhAKBgQCoZkFGm9oLTqjeXZAq6j5S6i7K20V0lNdBBLqfmFBIRuTkYxhs4vUYnWjZrKRAd5bp6_py0csmFmpl_5Yh0b-2pdo_E5PNP7LGRzKyKSiFddyykKKzVOazH8YYldDAfE8Z5HoS9e48an5JsPg0jr-TPu34DnJq3yv2a6dqiKL9zSCakQYSlQEKkgEIEBAAGocBMIGEAoGBALhrihbf3EpjDQS2sCQHazoFgN0nBbE9eesnnFTfzQELXb2gnJU9enmV_aDqaHKjgtLIPpCgn40lHrn5k6mvH5OdedyI6cCzE-N-GFp3nAq0NDJyMe0fhtIRD__CbT0ulcvkeow65ubXWfw6dBC2gR_34rdMe_L_TGRLMWjDULbNIJqRBg\n",
                                  TUnittest::GetPublicKeys());
    }

    Y_UNIT_TEST(service) {
        const int src = 117;
        const int dst = 118;

        TString s = TUnittest::GetServiceTicket(src, dst, {"qwe", "wer"}, 0);
        s.pop_back();
        UNIT_ASSERT_STRINGS_EQUAL("3:serv:CBAQ__________9_Ig4IdRB2GgNxd2UaA3dlcg:", s.substr(0, 46));

        UNIT_ASSERT(!NTvmAuth::TServiceContext::CheckingFactory(src, TUnittest::GetPublicKeys()).Check(s));
        UNIT_ASSERT(NTvmAuth::TServiceContext::CheckingFactory(dst, TUnittest::GetPublicKeys()).Check(s));

        s = TUnittest::GetServiceTicket(src, dst, {"qwe", "wer"}, 789);
        s.pop_back();
        UNIT_ASSERT_STRINGS_EQUAL("3:serv:CBAQ__________9_IhEIdRB2GgNxd2UaA3dlciCVBg:", s.substr(0, 50));

        UNIT_ASSERT(!NTvmAuth::TServiceContext::CheckingFactory(src, TUnittest::GetPublicKeys()).Check(s));
        UNIT_ASSERT(NTvmAuth::TServiceContext::CheckingFactory(dst, TUnittest::GetPublicKeys()).Check(s));
    }

    Y_UNIT_TEST(userEnv) {
        const ui64 uid = 100500;
        const std::vector<TString> scopes = {"qwe", "wer"};

        {
            TString s = TUnittest::GetUserTicket(uid, {uid}, scopes, "test");
            s.pop_back();
            UNIT_ASSERT_STRINGS_EQUAL("3:user:CA0Q__________9_GhwKBAiUkQYQlJEGGgNxd2UaA3dlciDShdjMBCgB:",
                                      NTvmAuth::NUtils::RemoveTicketSignature(s));
            UNIT_ASSERT(!NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::Prod, TUnittest::GetPublicKeys()).Check(s));
            UNIT_ASSERT(NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::Test, TUnittest::GetPublicKeys()).Check(s));
        }
        {
            TString s = TUnittest::GetUserTicket(uid, {uid}, scopes, "prod");
            s.pop_back();
            UNIT_ASSERT_STRINGS_EQUAL("3:user:CAsQ__________9_GhwKBAiUkQYQlJEGGgNxd2UaA3dlciDShdjMBCgA:",
                                      NTvmAuth::NUtils::RemoveTicketSignature(s));
            UNIT_ASSERT(NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::Prod, TUnittest::GetPublicKeys()).Check(s));
            UNIT_ASSERT(!NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::Test, TUnittest::GetPublicKeys()).Check(s));
        }
        {
            TString s = TUnittest::GetUserTicket(uid, {uid}, scopes, "prod_yateam");
            s.pop_back();
            UNIT_ASSERT_STRINGS_EQUAL("3:user:CAwQ__________9_GhwKBAiUkQYQlJEGGgNxd2UaA3dlciDShdjMBCgC:",
                                      NTvmAuth::NUtils::RemoveTicketSignature(s));
            UNIT_ASSERT(!NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::Prod, TUnittest::GetPublicKeys()).Check(s));
            UNIT_ASSERT(NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::ProdYateam, TUnittest::GetPublicKeys()).Check(s));
        }
        {
            TString s = TUnittest::GetUserTicket(uid, {uid}, scopes, "test_yateam");
            s.pop_back();
            UNIT_ASSERT_STRINGS_EQUAL("3:user:CA4Q__________9_GhwKBAiUkQYQlJEGGgNxd2UaA3dlciDShdjMBCgD:",
                                      NTvmAuth::NUtils::RemoveTicketSignature(s));
            UNIT_ASSERT(!NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::Prod, TUnittest::GetPublicKeys()).Check(s));
            UNIT_ASSERT(NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::TestYateam, TUnittest::GetPublicKeys()).Check(s));
        }
        {
            TString s = TUnittest::GetUserTicket(uid, {uid}, scopes, "stress");
            s.pop_back();
            UNIT_ASSERT_STRINGS_EQUAL("3:user:CA8Q__________9_GhwKBAiUkQYQlJEGGgNxd2UaA3dlciDShdjMBCgE:",
                                      NTvmAuth::NUtils::RemoveTicketSignature(s));
            UNIT_ASSERT(!NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::Test, TUnittest::GetPublicKeys()).Check(s));
            UNIT_ASSERT(NTvmAuth::TUserContext(NTvmAuth::EBlackboxEnv::Stress, TUnittest::GetPublicKeys()).Check(s));
        }

        UNIT_ASSERT_EXCEPTION(TUnittest::GetUserTicket(uid, {uid}, scopes, ""), yexception);
        UNIT_ASSERT_EXCEPTION(TUnittest::GetUserTicket(uid, {uid}, scopes, "ololo"), yexception);
        UNIT_ASSERT_EXCEPTION(TUnittest::GetUserTicket(uid, {uid}, scopes, "Prod"), yexception);
    }

    Y_UNIT_TEST(userUids) {
        const NTvmAuth::TUserContext ctx(NTvmAuth::EBlackboxEnv::Test, TUnittest::GetPublicKeys());
        const std::vector<TString> scopes = {"qwe", "wer"};

        {
            TString s = TUnittest::GetUserTicket(100500, {100500, 100500, 100500, 100500}, scopes, "test");
            s.pop_back();
            UNIT_ASSERT_STRINGS_EQUAL("3:user:CA0Q__________9_GhwKBAiUkQYQlJEGGgNxd2UaA3dlciDShdjMBCgB:",
                                      NTvmAuth::NUtils::RemoveTicketSignature(s));
            NTvmAuth::TCheckedUserTicket ut = ctx.Check(s);
            UNIT_ASSERT_VALUES_EQUAL(100500, ut.GetDefaultUid());
            UNIT_ASSERT_EQUAL(NTvmAuth::TUids{100500}, ut.GetUids());
        }
        {
            TString s = TUnittest::GetUserTicket(100500, {100501, 100502, 100503, 100504}, scopes, "test");
            s.pop_back();
            UNIT_ASSERT_STRINGS_EQUAL("3:user:CA0Q__________9_GjQKBAiUkQYKBAiVkQYKBAiWkQYKBAiXkQYKBAiYkQYQlJEGGgNxd2UaA3dlciDShdjMBCgB:",
                                      NTvmAuth::NUtils::RemoveTicketSignature(s));
            NTvmAuth::TCheckedUserTicket ut = ctx.Check(s);
            UNIT_ASSERT_VALUES_EQUAL(100500, ut.GetDefaultUid());
            UNIT_ASSERT_EQUAL(NTvmAuth::TUids({100500, 100501, 100502, 100503, 100504}), ut.GetUids());
        }
        {
            TString s = TUnittest::GetUserTicket(0, {100501, 100502, 100503, 100504}, scopes, "test");
            s.pop_back();
            UNIT_ASSERT_STRINGS_EQUAL("3:user:CA0Q__________9_GiwKBAiVkQYKBAiWkQYKBAiXkQYKBAiYkQYQABoDcXdlGgN3ZXIg0oXYzAQoAQ:",
                                      NTvmAuth::NUtils::RemoveTicketSignature(s));
            NTvmAuth::TCheckedUserTicket ut = ctx.Check(s);
            UNIT_ASSERT_VALUES_EQUAL(0, ut.GetDefaultUid());
            UNIT_ASSERT_EQUAL(NTvmAuth::TUids({100501, 100502, 100503, 100504}), ut.GetUids());
        }
    }
}
