#pragma once

#include "result.h"

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

namespace NPassport::NLast {
    class TPerformResult;
    class TTestContext;

    class TCheckProcessor {
    public:
        TCheckProcessor(const TTestContext& ctx, const TPerformResult& result);

        bool Process(TString& output);

    private:
        TString MakeOutput(const TString& output, bool isSuccess) const;

        bool CheckHeaderLine(TStringBuf header);
        bool CheckStatusLine(TStringBuf line);
        bool CheckCookie(const TString& cookie);
        bool CheckHeaders();
        bool CheckPostPerform(TString& output);
        void CheckResultItem(TString& output, const TResultItem* item);

    private:
        const TTestContext& Ctx_;
        const TPerformResult& PerformResult_;

        const TResult* CurResult_;
        TResult::TCookieArray ExpectedCookies_;
        TResult::THeaders ExpectedHeaders_;

        TString ErrorMsg_;
        TString ContentType_;
    };

}
