#include "check_expires_time.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/utils/session_utils.h>

#include <util/datetime/base.h>

namespace NPassport::NLast::NCheck {
    //
    // Check cookie Expires attribute
    //
    bool CheckExpiresTime(
        const TTestContext&,
        const TString& input,
        const NPassport::NLast::TFunctionArgs& args) {
        NPassport::NLast::TFunctionArgs::const_iterator it;

        // Locate 'time' argument (which is delta-from-now, in sec)
        // and convert it to numeric
        it = args.find("time");
        if (it == args.end()) {
            throw TLastError() << "CheckExpiresTime(): no 'time' argument";
        }

        // Calculate received time
        time_t received;
        if (!ParseRFC822DateTimeDeprecated(input.c_str(), received)) {
            throw TLastError() << "Couldn't parse expires timestamp '" << input << "'";
        }

        // Calculate expected time. Handle special cases separately.
        if (it->second.Value() == "MAX_INT") {
            return received >= 0x7FFFFFFF;
        }
        if (it->second.Value() == "EPOCH") {
            return received < 5;
        }
        time_t expected = CalcTimeFromDelta(it->second);
        return TimesClose(received, expected);
    }
}
