#include "check_match_regex.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/utils/url_decode.h>

#include <regex>

namespace NPassport::NLast::NCheck {
    bool CheckRegexExtended(
        const TTestContext& ctx,
        const TString& input,
        const NPassport::NLast::TFunctionArgs& args) {
        for (const auto& pair : args) {
            bool mustMatch = pair.first != "dontmatch";
            try {
                TString exp(pair.second);
                TString expanded(SubstituteVars(exp, ctx, true));
                std::regex regex(expanded.cbegin(), expanded.cend());
                bool matched = false;
                if (pair.first == "hex") {
                    TString rgx = HexDecode(input);
                    matched = std::regex_search(rgx.cbegin(), rgx.cend(), regex);
                } else {
                    matched = std::regex_search(input.cbegin(), input.cend(), regex);
                }

                if (matched != mustMatch) {
                    throw TMatchError() << "Value: <" << input
                                        << ">, Regex: <" << expanded
                                        << "> original: <" << exp << ">"
                                        << (mustMatch ? " (MUST match)" : " (must NOT match)");
                }
            } catch (const TMatchError& e) {
                throw;
            } catch (const std::exception& e) {
                throw TLastError() << "CheckRegex(): couldn't compile exp: " << pair.second << ": " << e.what();
            }
        }

        return true;
    }
}
