#include "check_match_xpath.h"

#include "common.h"

#include <passport/infra/libs/cpp/xml/config.h>

namespace NPassport::NLast::NCheck {
    bool CheckXPath(const TTestContext& ctx, const TString& input, const NPassport::NLast::TFunctionArgs& args) {
        NXml::TConfig doc = NXml::TConfig::ReadFromMemory(input);

        for (const auto& pair : args) {
            const TString& xpath = pair.first;
            const TString& result = pair.second;

            bool mustMatch = result != "dontmatch";
            try {
                TString value;
                try {
                    value = doc.AsString(xpath,
                                         NXml::TConfig::EFetchContent::All); // to read CDATA
                } catch (NXml::TConfig::TMissingException& e) {
                    if (!mustMatch) {
                        continue;
                    }
                    throw TMatchError() << "XPath does not exist: " << xpath;
                } catch (NXml::TConfig::TEmptyException&) {
                }

                if (mustMatch && pair.second.Match(value, ctx)) {
                    continue;
                }

                throw TMatchError() << "Xpath: <" << xpath
                                    << "> original: <" << result
                                    << ">, actual: <" << value
                                    << ">, check: <" << pair.second.CheckInfo() << ">";
            } catch (const TMatchError& e) {
                throw;
            } catch (const TLastError& e) {
                throw;
            } catch (const std::exception& e) {
                throw TLastError() << "CheckXPath(): couldn't compile xpath: " << xpath << ": " << e.what();
            }
        }

        return true;
    }
}
