#include "check_service_ticket.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/context/ticket_context.h>

#include <library/cpp/tvmauth/deprecated/service_context.h>

#include <util/generic/maybe.h>

namespace NPassport::NLast::NCheck {
    bool CheckServiceTicket(const TTestContext&, const TString& input, const NPassport::NLast::TFunctionArgs& args) {
        auto it = args.find("src");
        if (it == args.end()) {
            throw TLastError() << "CheckServiceTicket(): no 'src' argument";
        }
        NTvmAuth::TTvmId src = IntFromString<NTvmAuth::TTvmId, 10>(it->second.Value());

        it = args.find("dst");
        if (it == args.end()) {
            throw TLastError() << "CheckServiceTicket(): no 'dst' argument";
        }
        NTvmAuth::TTvmId dst = IntFromString<NTvmAuth::TTvmId, 10>(it->second.Value());

        NTvmAuth::TCheckedServiceTicket t = NTvmAuth::TServiceContext::CheckingFactory(
                                                dst,
                                                TTicketContext::GetInstance().TvmPublicKeys())
                                                .Check(input);
        if (!t) {
            throw TMatchError() << "Service ticket is bad:" << NTvmAuth::StatusToString(t.GetStatus());
        }
        if (t.GetSrc() != src) {
            throw TMatchError() << "Service ticket has wrong src:" << t.GetSrc() << ". Expected: " << src;
        }

        if (t.GetIssuerUid()) {
            throw TMatchError() << "Service ticket has issuer uid: " << *t.GetIssuerUid()
                                << ". There is no one possibility for service ticket to have issuer uid in ylast";
        }

        return true;
    }
}
