#include "check_sess_guard.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/context/sess_context.h>

#include <passport/infra/libs/cpp/auth_core/sessguard_parser.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NLast::NCheck {
    bool CheckSessGuard(
        const TTestContext& ctx,
        const TString& input,
        const NPassport::NLast::TFunctionArgs& args) {
        TSessContext::GetInstance();
        NPassport::NLast::TFunctionArgs::const_iterator it;

        it = args.find("host");
        if (it == args.end()) {
            throw TLastError() << "checkSessGuard(): no 'host' argument";
        }

        NAuth::TSessGuard guard = TSessContext::GetInstance().GuardParser().ParseGuard(input, it->second.Value());

        it = args.find("status");
        if (it == args.end()) {
            throw TLastError() << "checkSessGuard(): no 'status' argument";
        }

        if ((it->second.Value() == "valid" && guard.Status() != NAuth::TSessGuard::VALID) ||
            (it->second.Value() == "invalid" && guard.Status() != NAuth::TSessGuard::INVALID)) {
            CheckField("Sessguard", input, "status", it->second.Value(), IntToString<10>((int)guard.Status()));
        }

        // check time delta (keep the same parameter and logic as in checkSessionId)
        time_t create_time = std::time(nullptr);
        it = args.find("time");
        if (it != args.end()) {
            create_time += NUtils::ToInt(it->second.Value(), "time");
        }

        if (!TimesClose(create_time, guard.CreateTime())) {
            // use "checkField" to fail the check and report error
            CheckField("Sessguard", input, "createTime", create_time, guard.CreateTime());
        }

        CheckStringField("Sessguard", ctx, input, args, "version", IntToString<10>(guard.Version()));
        CheckStringField("Sessguard", ctx, input, args, "authid", guard.AuthId());
        CheckStringField("Sessguard", ctx, input, args, "keyspace", guard.Keyspace());
        CheckStringField("Sessguard", ctx, input, args, "guardspace", guard.Guardspace());

        return true;
    }
}
