#include "check_tvm_public_keys.h"

#include "common.h"

#include <library/cpp/tvmauth/src/parser.h>
#include <library/cpp/tvmauth/src/protos/tvm_keys.pb.h>

namespace NPassport::NLast::NCheck {
    bool CheckTvmPublicKeys(const TTestContext& ctx, const TString& input, const NPassport::NLast::TFunctionArgs& args) {
        TString protoBin = NTvmAuth::TParserTvmKeys::ParseStrV1(input);
        tvm_keys::Keys keys;
        if (!keys.ParseFromString(protoBin)) {
            throw TLastError() << "Failed to parse protobuf";
        }

        auto check = [&args, &ctx](const TString& name, size_t actualVal) {
            auto it = args.find(name);
            if (it == args.end()) {
                throw TLastError() << "Expected '" << name << "'";
            }
            if (!it->second.Match(IntToString<10>(actualVal), ctx)) {
                throw TMatchError() << "Keys:" << it->first << ". expected <" << it->second.Value() << ">, actual <"
                                    << actualVal << ">, checkinfo: <" << it->second.CheckInfo() << ">";
            }
        };

        auto checkBb = [&keys, &check](const TString& name, tvm_keys::BbEnvType env) {
            size_t count = 0;
            for (int idx = 0; idx < keys.bb_size(); ++idx) {
                if (keys.bb(idx).env() == env) {
                    ++count;
                }
            }
            check(name, count);
        };

        check("tvm_count", keys.tvm_size());
        checkBb("bb_prod_count", tvm_keys::Prod);
        checkBb("bb_prod_yateam_count", tvm_keys::ProdYateam);
        checkBb("bb_test_count", tvm_keys::Test);
        checkBb("bb_test_yateam_count", tvm_keys::TestYateam);
        checkBb("bb_stress_count", tvm_keys::Stress);

        return true;
    }
}
