#include "check_unixtime.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/utils/session_utils.h>

namespace NPassport::NLast::NCheck {
    bool CheckUnixtime(const TTestContext&, const TString& input, const NPassport::NLast::TFunctionArgs& args) {
        // Locate 'time' argument (which is delta-from-now, in sec)
        // and convert it to numeric
        auto it = args.find("time");
        if (it == args.end()) {
            throw TLastError() << "CheckUnixTime(): no 'time' argument";
        }

        // Calculate received time
        time_t received = IntFromString<time_t, 10>(input);

        // Calculate expected time. Handle special cases separately.
        if (it->second.Value() == "MAX_INT") {
            return received >= 0x7FFFFFFF;
        }
        if (it->second.Value() == "EPOCH") {
            return received < 5;
        }
        time_t expected = CalcTimeFromDelta(it->second);

        time_t allowedDelta = 10;
        it = args.find("allowed_delta");
        if (it != args.end()) {
            Y_ENSURE(TryIntFromString<10>(input, allowedDelta));
        }

        return TimesClose(received, expected, allowedDelta);
    }
}
