#include "check_user_ticket.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/context/ticket_context.h>

#include <library/cpp/tvmauth/deprecated/user_context.h>

namespace NPassport::NLast::NCheck {
    bool CheckUserTicket(const TTestContext& ctx, const TString& input, const NPassport::NLast::TFunctionArgs& args) {
        NTvmAuth::TUserContext userCtx(NTvmAuth::EBlackboxEnv::Test,
                                       TTicketContext::GetInstance().TvmPublicKeys());
        NTvmAuth::TCheckedUserTicket ticket = userCtx.Check(input);
        if (!ticket) {
            throw TMatchError() << "User ticket is bad: " << NTvmAuth::StatusToString(ticket.GetStatus());
        }

        auto it = args.find("default_uid");
        if (it == args.end()) {
            throw TLastError() << "CheckUserTicket(): no 'default_uid' argument";
        }
        if (ticket.GetDefaultUid() != IntFromString<ui64, 10>(it->second.Value())) {
            throw TMatchError() << "User ticket has wrong default uid:" << ticket.GetDefaultUid()
                                << ". Expected: " << it->second.Value();
        }

        it = args.find("scopes");
        if (it == args.end()) {
            throw TLastError() << "CheckUserTicket(): no 'scopes' argument";
        }
        TString actScopes;
        for (TStringBuf s : ticket.GetScopes()) {
            actScopes.append(s).push_back(',');
        }
        if (!actScopes.empty()) {
            actScopes.pop_back();
        }
        if (actScopes != it->second.Value()) {
            throw TMatchError() << "User ticket has wrong scopes uid: " << actScopes
                                << ". Expected: " << it->second.Value();
        }

        auto its = args.equal_range("uid");
        if (its.first == its.second) {
            throw TLastError() << "CheckUserTicket(): no 'uid' argument";
        }
        for (auto it = its.first; it != its.second; ++it) {
            if (it->second.ResMod() == TArg::KeyCount) {
                TString count = IntToString<10>(ticket.GetUids().size());
                if (!it->second.Match(count, ctx)) {
                    throw TMatchError()
                        << "User ticket has uid count: " << count << ". Expected: " << it->second.Value()
                        << ". Check: " << it->second.CheckInfo();
                }
            } else {
                bool isOk = false;
                for (ui64 uid : ticket.GetUids()) {
                    if (uid == IntFromString<ui64, 10>(it->second.Value())) {
                        isOk = true;
                        break;
                    }
                }

                if (!isOk) {
                    TStringStream s;
                    s << "User ticket has not expected uid: " << it->second.Value();
                    s << ". Exist: ";
                    for (ui64 uid : ticket.GetUids()) {
                        s << uid << ',';
                    }
                    throw TMatchError() << s.Str();
                }
            }
        }

        return true;
    }
}
