#include "check_yp.h"
#include "check_unixtime.h"

#include "common.h"

#include <passport/infra/libs/cpp/yp_cookie_parser/yp_cookie_parser.h>

namespace NPassport::NLast::NCheck {
    bool CheckYp(const TTestContext& ctx, const TString& input, const NPassport::NLast::TFunctionArgs& args) {
        auto it = args.find("name");
        if (it == args.end()) {
            throw TLastError() << "CheckYp(): no 'name' argument";
        }

        TString value;
        if (!NYpCookie::TryGetYandexPermanentCookieKey(it->second.Value(), input, value)) {
            return false;
        }
        return CheckUnixtime(ctx, value, args);
    }
}
