#include "common.h"

namespace NPassport::NLast::NCheck {
    void CheckStringField(const TString& entity_name,
                          const TTestContext& ctx,
                          const TString& input,
                          const TFunctionArgs& args,
                          const TString& field,
                          const TString& actual) {
        const auto it = args.find(field);
        if (it != args.end()) {
            CheckField(entity_name, input, field, SubstituteVars(it->second.Value(), ctx), actual);
        }
    }

    bool TimesClose(time_t ts1, time_t ts2, unsigned allowed_delta) {
        return std::abs(ts1 - ts2) <= allowed_delta;
    }
}
