#pragma once

#include <passport/infra/tools/ylast/src/error.h>
#include <passport/infra/tools/ylast/src/func.h>

#include <util/string/cast.h>

namespace NPassport::NLast::NCheck {
    template <typename T>
    inline void CheckField(const TString& entity_name,
                           const TString& input,
                           const TString& field,
                           const T& expected,
                           const T& actual) {
        if (expected == actual) {
            return; // OK
        }

        throw TMatchError() << entity_name << ": <" << input << "> field: <" << field
                            << "> expected: <" << expected << ">, actual: <" << actual << ">";
    }

    void CheckStringField(const TString& entity_name,
                          const TTestContext& ctx,
                          const TString& input,
                          const NPassport::NLast::TFunctionArgs& args,
                          const TString& field,
                          const TString& actual);

    // check that ts is "the same" (with some gap allowed)
    bool TimesClose(time_t ts1, time_t ts2, unsigned allowed_delta = 10);
}
