#include "facade.h"

#include "check_expires_time.h"
#include "check_ignore.h"
#include "check_json_point.h"
#include "check_match_regex.h"
#include "check_match_xpath.h"
#include "check_oauth_token.h"
#include "check_service_ticket.h"
#include "check_sess_guard.h"
#include "check_sessionid.h"
#include "check_tvm_public_keys.h"
#include "check_unixtime.h"
#include "check_user_ticket.h"
#include "check_yes.h"
#include "check_yp.h"

#include <passport/infra/tools/ylast/src/func.h>

#include <util/generic/yexception.h>

namespace NPassport::NLast::NCheck {
    static const std::map<TString, TCheckFunctions::TFunc> FUNCTIONS_ = {
        {"checkexpires", CheckExpiresTime},
        {"check_service_ticket", CheckServiceTicket},
        {"checksessguard", CheckSessGuard},
        {"checksessid", CheckSessionId},
        {"checktoken", CheckOAuthToken},
        {"check_tvm_public_keys", CheckTvmPublicKeys},
        {"checkunixtime", CheckUnixtime},
        {"check_user_ticket", CheckUserTicket},
        {"check_yp_with_ts", CheckYp},
        {"ignore", CheckIgnore},
        {"matchjsonpoint", CheckJsonPath},
        {"matchregex", CheckRegexExtended},
        {"matchregex_extended", CheckRegexExtended},
        {"matchxpath", CheckXPath},
        {"yes", CheckYes},
    };

    TCheckFunctions::TFunc TCheckFunctions::Lookup(const TString& fname) {
        auto it = FUNCTIONS_.find(fname);

        Y_ENSURE(it != FUNCTIONS_.end(),
                 "Unregistered check-function '" << fname << "'");

        return it->second;
    }
}
