#pragma once

#include <passport/infra/libs/cpp/auth_core/gamma/gamma_keeper.h>

#include <util/generic/string.h>
#include <util/system/types.h>

#include <map>
#include <set>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NLast {
    class TConfig {
    public:
        static const TConfig& Get();
        static TConfig& GetMutable();
        static void Init(const TString& file);

        TConfig();
        ~TConfig();

    private:
        void Parse(const TString& file);

    public:
        //
        // Ignore failed cases and continue through the test
        //
        bool IgnoreErrors = false;

        //
        // Print out parsed ("human-readable") scenarion in the beginning
        //
        bool ShowParsedScen = false;

        //
        // Verbose mode. For now -- just print out HTTP communication trace
        //
        bool ShowHttpTrace = false;

        // Quiet output
        bool Quiet = false;

        //
        // DB parameters
        //
        struct TDbConf {
            TString DbDriver;
            TString DbHost;
            ui16 DbPort = 0U;
            TString DbUser;
            TString DbPassword;
            TString DbName;
            TString KeyPath;
        };

        TDbConf PasspDb;
        TDbConf TvmDb;

        TString TvmPublicKeysUrl;

        //
        // Cases selected for execution. Empty set means 'all'
        //
        std::set<TString> Cases;

        //
        // Custom URL, if specified
        //
        TString Url;

        TString UrlOauth;

        bool PrintUnused = false;

        struct TXServiceTicket {
            TString TvmHost;
            ui32 TvmPort = 0U;
            ui32 Dst = 0;
            std::map<ui32, TString> Clients; // id, secret
        } XServiceTicket;

        struct TXUserTicket {
            TString TvmSecret;
            ui32 TvmId;
        };
        std::optional<TXUserTicket> XUserTicket;

        struct TGuardSpace {
            TString Id;
            TString Name;
            std::vector<TString> Hostnames;
        };
        std::vector<TGuardSpace> GuardSpaces;

        size_t Threads = 1;

        NAuth::TGammaKeeperSettings GammaKeeperSettings;

        TString BlackboxHost;

    private:
        static void ParseDb(const NXml::TConfig& config, const TString& path, TDbConf& db);
    };
}
