#pragma once

#include "utils/curlwrap.h"

#include <util/generic/string.h>

namespace NPassport::NLast {
    class TTestContext;

    class TPerformResult {
    public:
        void Clear();

        long HttpCode = 0;

        // for curl
        TString Output;
        TString InHdr;
        TString Page;

        // for print
        TString Request;
    };

    class TConnection {
    public:
        TConnection();

        const TPerformResult& Perform(const TTestContext& ctx);

    private:
        static TString MakeUrl(const TTestContext& ctx);
        static TString MakeRequest(const TTestContext& ctx);
        static void MakeHeaders(const TTestContext& ctx, NCurlwrap::TSlist& headers);
        static TString MakeCookies(const TTestContext& ctx);

        static int DebugCallback(
            CURL*,              /* the handle/transfer this concerns */
            curl_infotype type, /* what kind of data */
            char* data,         /* points to the data (not-NULL terminated) */
            size_t size,        /* size of the data pointed to */
            void* userptr);

        static size_t WriteCallback(
            char* buffer,
            size_t size,
            size_t nitems,
            void* outstream);

        static size_t HeadersCallback(
            void* header,
            size_t size,
            size_t nitems,
            void* arg);

    private:
        NCurlwrap::THandle Handle_;
        TPerformResult PerfRes_;
    };

}
