#include "lah_context.h"

#include <passport/infra/tools/ylast/src/config.h>

#include <passport/infra/daemons/sezamapi/src/utils/utils.h>
#include <passport/infra/libs/cpp/json/reader.h>
#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/split.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <library/cpp/http/simple/http_client.h>

namespace NPassport::NLast {
    static std::vector<TString> FetchLRandoms(TStringBuf endpoint) {
        TStringStream out;
        TSimpleHttpClient(TSimpleHttpClientOptions(endpoint)).DoGet("/lrandoms.txt", &out);
        TString body = out.Str();
        std::vector<TString> keys = NUtils::ToVector(body, '\n', 6000);

        std::vector<TString> curKeyFields = NUtils::ToVector(keys.back(), ';');
        if (curKeyFields.size() < 2) {
            throw yexception() << "lrandoms malformed. url " << endpoint << "/lrandoms.txt. lrandoms : " << body;
        }

        return curKeyFields;
    }

    TLahContext& TLahContext::GetIns() {
        static TLahContext ins;
        return ins;
    }

    TString TLahContext::MakeLahV2(const NSezamApi::TLahAccounts& accs) const {
        TString protoStr = NSezamApi::TUtils::SerializeLahData(accs);
        TStringStream buf;
        TString request = NUtils::CreateStr("method=sign&ttl=3600&sign_space=lah&format=json&value=", NUtils::Bin2base64url(protoStr));
        TSimpleHttpClient(TSimpleHttpClientOptions(BbEndpoint_)).DoPost("/blackbox", request, &buf);

        rapidjson::Document document;
        TString signedValue;
        Y_ENSURE(NJson::TReader::DocumentAsObject(buf.Str(), document), "Failed to parse JSON: " << buf.Str());
        Y_ENSURE(NJson::TReader::MemberAsString(document, "signed_value", signedValue), "Failed to get signed_value from " << buf.Str());

        return NUtils::CreateStr("2:", signedValue);
    }

    TLahContext::TLahContext() {
        TStringBuf scheme;
        TStringBuf host;
        ui16 port = 0;
        GetSchemeHostAndPort(TConfig::Get().Url, scheme, host, port);
        BbEndpoint_ = NUtils::CreateStr(scheme, TConfig::Get().BlackboxHost, ":", port);

        std::vector<TString> curKeyFields = FetchLRandoms(BbEndpoint_);
        KeyId_ = std::move(curKeyFields.at(0));
        Key_ = std::move(curKeyFields.at(1));
    }
}
