#include "oauth_context.h"

#include <passport/infra/tools/ylast/src/config.h>
#include <passport/infra/tools/ylast/src/error.h>
#include <passport/infra/tools/ylast/src/utils/session_utils.h>

#include <passport/infra/libs/cpp/auth_core/keyring.h>
#include <passport/infra/libs/cpp/auth_core/oauth_token_parser.h>

namespace NPassport::NLast {
    TOAuthContext& TOAuthContext::GetInstance() {
        static TOAuthContext ins;
        return ins;
    }

    TOAuthContext::TOAuthContext() {
        const TConfig::TDbConf& config = TConfig::Get().PasspDb;
        auto dsn = NDbPool::TDestination::Create(
            config.DbDriver,
            config.DbUser,
            config.DbPassword,
            config.DbName,
            "",
            "",
            {{"ssl_mode", "SSL_MODE_DISABLED"}});
        Pool_ = std::make_unique<NDbPool::TDbPool>(
            NDbPool::TDbPoolSettings{
                .Dsn = dsn,
                .Hosts = {{
                    config.DbHost,
                    config.DbPort,
                }},
            });
        OauthParser = std::make_unique<NAuth::TOAuthTokenParser>(
            *Pool_,
            NAuth::TKeyRingSettings{
                .Signkeydepth = 2,
                .GammaKeeper = NAuth::TGammaKeeper::Create(
                    NAuth::TGammaKeeperSettings(TConfig::Get().GammaKeeperSettings)),
            });
    }
}
