#pragma once

#include <passport/infra/libs/cpp/dbpool/db_pool.h>
#include <passport/infra/libs/cpp/dbpool/handle.h>

#include <util/generic/noncopyable.h>

#include <memory>

namespace NPassport::NAuth {
    class TOAuthTokenParser;
}
namespace NPassport::NLast {
    class TOAuthContext: TNonCopyable {
    public:
        static TOAuthContext& GetInstance();

        std::unique_ptr<NAuth::TOAuthTokenParser> OauthParser;

    private:
        explicit TOAuthContext();

        std::unique_ptr<NDbPool::TDbPool> Pool_;
    };

}
