#include "sess_context.h"

#include <passport/infra/tools/ylast/src/config.h>
#include <passport/infra/tools/ylast/src/error.h>
#include <passport/infra/tools/ylast/src/utils/session_utils.h>

#include <passport/infra/libs/cpp/auth_core/session.h>

#include <vector>

namespace NPassport::NLast {
    TSessContext& TSessContext::GetInstance() {
        static TSessContext ins;
        return ins;
    }

    TSessContext::TSessContext() {
        const TConfig::TDbConf& config = TConfig::Get().PasspDb;
        // Init libauth
        NDbPool::TDestinationPtr dsn = NDbPool::TDestination::Create(
            config.DbDriver,
            config.DbUser,
            config.DbPassword,
            config.DbName,
            "",
            "",
            {{"ssl_mode", "SSL_MODE_DISABLED"}});
        Pool_ = std::make_unique<NDbPool::TDbPool>(NDbPool::TDbPoolSettings{
            .Dsn = dsn,
            .Hosts = {{
                config.DbHost,
                config.DbPort,
            }},
        });
        SessSigner_ = std::make_unique<NAuth::TSessionSigner>(
            *Pool_,
            NAuth::TKeyRingSettings{
                .GammaKeeper = NAuth::TGammaKeeper::Create(
                    NAuth::TGammaKeeperSettings(TConfig::Get().GammaKeeperSettings)),
            });
        SessParser_ = std::make_unique<NAuth::TSessionParser>(*SessSigner_, NAuth::EEnvironmentType::Testing);
        SessguardParser_ = std::make_unique<NAuth::TSessGuardParser>(*SessSigner_);
        TSessionContext::SetupDomainKeys(*Pool_, *SessSigner_);

        for (const TConfig::TGuardSpace& g : TConfig::Get().GuardSpaces) {
            SessguardParser_->AddGuardSpace(g.Id, g.Name, g.Hostnames);
        }
    }
}
