#pragma once

#include <passport/infra/libs/cpp/auth_core/sessguard_parser.h>
#include <passport/infra/libs/cpp/auth_core/sessionparser.h>
#include <passport/infra/libs/cpp/auth_core/sessionsigner.h>
#include <passport/infra/libs/cpp/dbpool/db_pool.h>
#include <passport/infra/libs/cpp/dbpool/handle.h>

#include <memory>

namespace NPassport::NLast {
    class TSessContext: TNonCopyable {
    public:
        static TSessContext& GetInstance();

        const NAuth::TSessionSigner& Signer() const {
            return *SessSigner_;
        }
        const NAuth::TSessionParser& Parser() const {
            return *SessParser_;
        }
        const NAuth::TSessGuardParser& GuardParser() const {
            return *SessguardParser_;
        }

    private:
        TSessContext();

        std::unique_ptr<NDbPool::TDbPool> Pool_;
        std::unique_ptr<NAuth::TSessionSigner> SessSigner_;
        std::unique_ptr<NAuth::TSessionParser> SessParser_;
        std::unique_ptr<NAuth::TSessGuardParser> SessguardParser_;
    };

}
