#pragma once

#include <passport/infra/tools/ylast/src/config.h>

#include <library/cpp/tvmauth/type.h>
#include <library/cpp/tvmauth/version.h>

#include <util/generic/noncopyable.h>

#include <memory>
#include <unordered_map>

namespace NPassport::NDbPool {
    class TResult;
}

namespace NPassport::NTvmCommon {
    class TDecryptor;
    class TPrivateKey;
}

namespace NPassport::NLast {
    class TTicketContext: TNonCopyable {
    public:
        static TTicketContext& GetInstance();

        const TString& GetSecret(const TString& clientId) const;
        const TString& GetOldSecret(const TString& clientId) const;
        const TString& TvmPublicKeys() const;

        const TString& ServiceTicket(NTvmAuth::TTvmId clientId) const;

        const NTvmCommon::TPrivateKey& GetPrivateKeys() const;

    private:
        using TSecrets = std::unordered_map<TString, TString>;

        TTicketContext(const TConfig& config);

        static void InitViaDb(const TConfig::TDbConf& conf,
                              TSecrets& secrets,
                              TSecrets& oldSecrets);
        void GetServiceTickets(const TConfig& config);

        static void ParseSecrets(NDbPool::TResult& res,
                                 const NTvmCommon::TDecryptor& decr,
                                 TSecrets& secrets);

        TSecrets Secrets_;
        TSecrets OldSecrets_;
        TString TvmPublicKeys_;

        std::unordered_map<NTvmAuth::TTvmId, TString> ServiceTickets_;

        std::unique_ptr<NTvmCommon::TPrivateKey> PrivKeys_;
    };

    inline const TString& TTicketContext::GetSecret(const TString& clientId) const {
        static const TString EMPTY_;
        auto it = Secrets_.find(clientId);
        if (it == Secrets_.end()) {
            return EMPTY_;
        }
        return it->second;
    }

    inline const TString& TTicketContext::GetOldSecret(const TString& clientId) const {
        static const TString EMPTY_;
        auto it = OldSecrets_.find(clientId);
        if (it == OldSecrets_.end()) {
            return EMPTY_;
        }
        return it->second;
    }

}
