#pragma once

#include "scenario.h"
#include "worker.h"

#include <util/generic/string.h>

namespace NPassport::NLast {
    class TEngine {
    public:
        TEngine();
        ~TEngine();

        bool Execute(const TScenario& scen);

    private:
        bool TestNode(const TNode& node, const TScenario& scen);
        bool TestCase(const TString& url, const TCase& testCase);

        bool ProcResult(TWorkerResult& res, size_t recievedCount, size_t totalCount);

    private:
        int Failures_ = 0;
        TWorkerPool Workers_;
    };

    class TTimeStatPrinter {
    public:
        TTimeStatPrinter(const char* msg)
            : Msg_(msg)
        {
            time(&Start_);
            Cout << Msg_ << " started at " << ctime(&Start_);
        }

        ~TTimeStatPrinter() {
            Cout << "------- " << Endl;
            time(&End_);
            Cout << Msg_ << " finished at " << ctime(&End_);

            time_t delta = End_ - Start_;
            Cout << "Time spent: " << delta / 60 << " min " << delta % 60 << " sec" << Endl;
        }

    private:
        time_t Start_ = 0;
        time_t End_ = 0;
        const char* Msg_;
    };

}
