#include "facade.h"

#include "gen_lah.h"
#include "gen_oauth_token.h"
#include "gen_service_ticket.h"
#include "gen_sess_guard.h"
#include "gen_sessionid.h"
#include "gen_unixtime.h"
#include "gen_user_ticket.h"
#include "gen_yp.h"

#include <passport/infra/tools/ylast/src/func.h>

#include <util/generic/yexception.h>

namespace NPassport::NLast::NGen {
    static const std::map<TString, TGenerateFunctions::TFunc> FUNCTIONS_ = {
        {"genlah", GenerateLah},
        {"gensessguard", GenerateSessGuard},
        {"gensessid", GenerateSessId},
        {"gentoken", GenerateOAuthToken},
        {"genunixtime", GenerateUnixtime},
        {"gen_user_ticket", GenerateUserTicket},
        {"get_service_ticket", GenerateServiceTicket},
        {"gen_yp", GenerateYp},
    };

    TGenerateFunctions::TFunc TGenerateFunctions::Lookup(const TString& fname) {
        auto it = FUNCTIONS_.find(fname);

        Y_ENSURE(it != FUNCTIONS_.end(),
                 "Unregistered generate-function '" << fname << "'");

        return it->second;
    }
}
