#include "gen_lah.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/context/lah_context.h>

#include <passport/infra/daemons/sezamapi/src/utils/lah_account.h>
#include <passport/infra/libs/cpp/utils/string/split.h>

namespace NPassport::NLast::NGen {
    static NSezamApi::TLahAccounts GenerateAccounts(const NPassport::NLast::TFunctionArgs& args) {
        using namespace NPassport::NSezamApi;

        auto range = args.equal_range("row");

        TLahAccounts set;
        for (auto it = range.first; it != range.second; ++it) {
            ui64 uid;
            time_t ts;
            ui32 method = 0;
            ::Split(TStringBuf(it->second.Value()), ';', uid, ts, method);

            set.insert(TLahAccount{
                .Uid = uid,
                .LastLoginTime = ts,
                .LoginMethod = method,
            });
        }

        if (set.empty()) {
            throw yexception() << "Cookie 'lah' cannot be without uids";
        }

        return set;
    }

    TString GenerateLah(const NPassport::NLast::TFunctionArgs& args) {
        auto it = args.find("version");

        if (it == args.end() || it->second.Value() == "2") {
            return TLahContext::GetIns().MakeLahV2(GenerateAccounts(args));
        }

        ythrow yexception() << "Unsupported cookie version " << it->second.Value();
    }
}
