#include "gen_service_ticket.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/context/ticket_context.h>

#include <library/cpp/tvmauth/type.h>

#include <util/string/cast.h>

namespace NPassport::NLast::NGen {
    TString GenerateServiceTicket(const NPassport::NLast::TFunctionArgs& args) {
        auto it = args.find("const_value");
        if (it != args.end()) {
            return it->second.Value();
        }

        it = args.find("dst");
        if (it == args.end()) {
            throw TLastError() << "@dst is required for 'get_service_ticket'";
        }
        return TTicketContext::GetInstance().ServiceTicket(IntFromString<NTvmAuth::TTvmId, 10>(it->second.Value()));
    }
}
