#include "gen_sess_guard.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/context/sess_context.h>
#include <passport/infra/tools/ylast/src/utils/session_utils.h>

#include <passport/infra/libs/cpp/auth_core/sessguard.h>

namespace NPassport::NLast::NGen {
    TString GenerateSessGuard(const NPassport::NLast::TFunctionArgs& args) {
        NPassport::NLast::TFunctionArgs::const_iterator it;
        TSessContext::GetInstance();

        it = args.find("authid");
        if (it == args.end()) {
            throw TLastError() << "GenerateSessGuard(): no 'authid' argument";
        }

        NAuth::TSessGuard guard(it->second.Value());

        // by default: sessguard created as of now
        TString time_delta("0");

        it = args.find("time");
        if (it != args.end()) {
            time_delta = it->second;
        }

        it = args.find("host");
        if (it == args.end()) {
            throw TLastError() << "GenerateSessGuard(): no 'host' argument";
        }

        TString domain; // not used here

        return TSessContext::GetInstance().GuardParser().MakeGuardStr(
            guard, it->second.Value(), domain, CalcTimeFromDelta(time_delta));
    }
}
