#include "gen_sessionid.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/context/sess_context.h>
#include <passport/infra/tools/ylast/src/utils/session_utils.h>

namespace NPassport::NLast::NGen {
    TString GenerateSessId(const NPassport::NLast::TFunctionArgs& args) {
        NPassport::NLast::TFunctionArgs::const_iterator it;
        TSessContext::GetInstance();

        // What type of SessionID shall be generated?
        it = args.find("type");
        if (it == args.end()) {
            throw TLastError() << "GenerateSessionId(): no 'type' argument";
        }

        if (it->second.Value() == "empty") {
            return "";
        }

        // Generate approriate cookie value
        TString ret;
        TIdComposer composer(args);

        if (it->second.Value() == "noauth") {
            ret = composer.NoAuth();
        } else if (it->second.Value() == "sign_broken") {
            ret = composer.SignBroken();
        } else if (it->second.Value() == "disabled") {
            ret = composer.Disabled();
        } else if (it->second.Value() == "valid") {
            ret = composer.Valid();
        } else if (it->second.Value() == "need_reset") {
            ret = composer.NeedReset();
        } else if (it->second.Value() == "expired") {
            ret = composer.Expired();
        } else if (it->second.Value() == "no_cookie") {
            ret = composer.NoCookie();
        } else if (it->second.Value() == "cant_check") {
            ret = TIdComposer::CantCheck();
        } else if (it->second.Value() == "validquoted") {
            ret = TStringBuilder() << '"' << composer.Valid() << '"';
        } else {
            throw TLastError() << "GenerateSessionId(): unsupported type '" << it->second.Value() << "'";
        }

        return ret;
    }
}
