#include "gen_unixtime.h"

#include "common.h"

#include <util/string/cast.h>

#include <time.h>

namespace NPassport::NLast::NGen {
    TString GenerateUnixtime(const NPassport::NLast::TFunctionArgs& args) {
        auto it = args.find("const_value");
        if (it != args.end()) {
            return it->second.Value();
        }

        it = args.find("time");
        if (it == args.end()) {
            throw TLastError() << "GenerateUnixtime(): no 'time' argument";
        }

        if (it->second.Value() == "MAX_INT") {
            return IntToString<10>(0x7FFFFFFF);
        }
        if (it->second.Value() == "EPOCH") {
            return IntToString<10>(time(nullptr));
        }
        return IntToString<10>(time(nullptr) + IntFromString<time_t, 10>(it->second.Value()));
    }
}
