#include "gen_user_ticket.h"

#include "common.h"

#include <passport/infra/tools/ylast/src/context/ticket_context.h>

#include <passport/infra/libs/cpp/tvm/common/private_key.h>
#include <passport/infra/libs/cpp/tvm/signer/signer.h>

#include <util/string/cast.h>

namespace NPassport::NLast::NGen {
    TString GenerateUserTicket(const NPassport::NLast::TFunctionArgs& args) {
        auto it = args.find("const_value");
        if (it != args.end()) {
            return it->second.Value();
        }

        it = args.find("default_uid");
        if (it == args.end()) {
            throw TLastError() << "@default_uid is required for 'gen_user_ticket'";
        }

        NPassport::NTicketSigner::TUserSigner b;
        b.SetDefaultUid(IntFromString<ui64, 10>(it->second.Value()));
        b.AddUid(IntFromString<ui64, 10>(it->second.Value()));

        auto pair = args.equal_range("uid");
        for (auto it = pair.first; it != pair.second; ++it) {
            b.AddUid(IntFromString<ui64, 10>(it->second.Value()));
        }

        b.SetEntryPoint(123);
        b.SetEnv(NTvmAuth::EBlackboxEnv::Test);
        return b.SerializeV3(*TTicketContext::GetInstance().GetPrivateKeys().GetKey(),
                             time(nullptr) + 100500);
    }
}
