#include "gen_yp.h"
#include "gen_unixtime.h"

#include "common.h"

#include <util/string/cast.h>

#include <time.h>

namespace NPassport::NLast::NGen {
    TString GenerateYp(const NPassport::NLast::TFunctionArgs& args) {
        TString value = GenerateUnixtime(args);
        auto it = args.find("name");
        if (it == args.end()) {
            throw TLastError() << "GenerateYp(): no 'name' argument";
        }
        TString name = it->second.Value();

        it = args.find("expired");
        if (it == args.end()) {
            throw TLastError() << "GenerateYp(): no 'expired' argument";
        }
        TString expired = it->second.Value();

        return expired + "." + name + "." + value;
    }
}
