#pragma once

#include <passport/infra/libs/cpp/xml/config.h>

#include <util/generic/string.h>

#include <optional>
#include <vector>

namespace NPassport::NLast::NLibretto {
    class TSingleElementError;

    //// Node set
    struct TPath {
        std::vector<TString> Values;
        bool WithNull = false;
    };

    struct TVariable {
        TString Name;
        TString Value;
        bool WithNull = false;
    };
    using TNodeVariables = std::vector<TVariable>;

    struct TCheckSet {
        TString Description;

        std::vector<TPath> Path;

        TNodeVariables Cgi;
        TNodeVariables Cookie;
        TNodeVariables Header;
    };

    struct TCheck {
        TCheckSet CheckSet;
        TString Result;
    };

    struct TCase {
        TCheckSet CheckSet;

        // Tvm
        bool TvmSignTs = false;
        bool Tvm2SignOld = false;
        bool Tvm2Sign = false;

        // Http
        bool IsPost = false;
        TString CustomMethod;

        int Redirects = 0;

        std::vector<TCheck> Checks;
    };

    struct TNode {
        TString Description;
        TString PreTestScript;
        TString PostTestScript;
        std::vector<TString> Url;
        bool SingleThreadOnly = false;

        std::vector<std::pair<TString, TCase>> Cases; // lastId -> case
    };
    ////

    //// Result set
    struct TResultItem;
    struct TArg {
        TString Name;
        TString ExpectedValue;

        TString Comparator;
        TString ResultModificator;
        bool DoesNeedSubstitute = false;
        std::optional<ui64> CompMin;
        std::optional<ui64> CompMax;

        std::unique_ptr<TResultItem> SubItem;
    };
    using TArgs = std::vector<TArg>;

    struct TResultItem {
        TString Name;
        TString Value;
        TString Func;

        TArgs Args;
    };
    using TResultItems = std::vector<TResultItem>;

    struct TSetCookie {
        TString Name;
        TResultItem Value;
        TResultItems Attribute;
        bool Ignore = false;
    };

    struct TResult {
        TString Name;
        int StatusCode = 0;
        std::vector<TSetCookie> SetCookie;
        TResultItems Header;

        std::optional<TResultItem> XmlBody;
        std::optional<TResultItem> JsonBody;
    };
    ////

    struct TNamedVar {
        TResultItem ResultItem;
        bool NeedPregeneration = false;
        std::vector<std::pair<TString, TResultItem>> Intanses; // id -> value
    };

    class TLibretto {
    public:
        TLibretto(const TString& filename);

        std::vector<TString> GetResultNames() const;
        TResult GetResult(const TString& name) const;
        std::vector<TNode> GetNodes() const;
        TNamedVar GetNamedVar(const TString& type, const TString& name, const TString& refList) const;

    private:
        enum class EWithName {
            True,
            False,
        };
        TResultItem ParseResultItem(const TString& path, EWithName withName) const;
        TSetCookie ParseSetCookie(const TString& path) const;
        TArg ParseArg(const TString& path) const;

        TNode ParseNode(const TString& path) const;
        std::pair<TString, TCase> ParseCase(const TString& path) const;
        TPath ParsePath(const TString& path) const;
        TCheck ParseCheck(const TString& path) const;
        TCheckSet ParseCheckSet(const TString& path) const;
        TVariable ParseVariable(const TString& path) const;

        bool WithNull(const TString& path) const;
        template <class T = TSingleElementError>
        void CheckSingle(const TString& path) const;

        enum class ECanBeEmpty {
            True,
            False,
        };
        TString GetSingleString(const TString& path, ECanBeEmpty canBeEmpty = ECanBeEmpty::False) const;
        std::optional<ui64> GetOptionalInt(const TString& path) const;

    private:
        NXml::TConfig Xml_;
    };
}
