#include "pregeneration.h"

#include <util/generic/yexception.h>

namespace NPassport::NLast {
    TPregeneration& TPregeneration::GetIns() {
        static TPregeneration ins;
        return ins;
    }

    void TPregeneration::Reset() {
        std::unique_lock lock(Mutex_);
        Values_.clear();
    }

    void TPregeneration::AddValue(const TString& cgi,
                                  const TString& id,
                                  TString&& value) {
        std::unique_lock lock(Mutex_);
        Values_[cgi][id] = std::move(value);
    }

    bool TPregeneration::HasValue(const TString& cgi, const TString& id) const {
        std::shared_lock lock(Mutex_);
        auto it = Values_.find(cgi);
        if (it == Values_.end()) {
            return false;
        }

        return it->second.contains(id);
    }

    const TString& TPregeneration::GetValue(const TString& cgi,
                                            const TString& id) const {
        std::shared_lock lock(Mutex_);
        auto it = Values_.find(cgi);
        if (it == Values_.end()) {
            throw yexception() << "Something strange. Cgi not found: " << cgi;
        }

        auto it2 = it->second.find(id);
        if (it2 == it->second.end()) {
            throw yexception() << "Something strange. Id not found: " << id << " in cgi " << cgi;
        }

        return it2->second;
    }

    bool TPregeneration::IsEmpty() const {
        std::shared_lock lock(Mutex_);
        return Values_.empty();
    }

}
