#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <shared_mutex>
#include <unordered_map>

namespace NPassport::NLast {
    class TPregeneration: TNonCopyable {
    public:
        static TPregeneration& GetIns();

        void Reset();
        void AddValue(const TString& cgi,
                      const TString& id,
                      TString&& value);

        bool HasValue(const TString& cgi,
                      const TString& id) const;
        const TString& GetValue(const TString& cgi,
                                const TString& id) const;

        bool IsEmpty() const;

    private:
        using TValues = std::unordered_map<TString, TString>; // id -> value
        using TCgis = std::unordered_map<TString, TValues>;   // cgi_name -> all_values
        TCgis Values_;
        mutable std::shared_timed_mutex Mutex_;
    };

}
