#include "result.h"

#include "libretto.h"
#include "scenario.h"

namespace NPassport::NLast {
    bool TStaticResultItem::Match(const TTestContext& ctx, const TString& v, bool) const {
        return SubstituteVars(Value_, ctx) == v;
    }

    TDynamicResultItem::TDynamicResultItem(const NLibretto::TResultItem& xitem)
        : Function_(xitem.Func)
    {
        for (const NLibretto::TArg& xarg : xitem.Args) {
            TArg arg(xarg);
            if (Function_.Contains("matchregex")) {
                arg.SetCompRegex();
            }

            AddArg(xarg.Name, std::move(arg));
        }
    }

    TDynamicResultItem::~TDynamicResultItem() = default;
}
