#include "regex_escape.h"

namespace NPassport::NLast {
    static const TString reservedChars("()[]\\+*?");

    TString RegexEscape(const TString& src) {
        TString dest;
        dest.reserve(src.size() + 30);

        for (const char c : src) {
            if (reservedChars.find(c) != TString::npos) {
                dest.push_back('\\');
            }
            dest.push_back(c);
        }

        return dest;
    }

}
