#pragma once

#include <passport/infra/tools/ylast/src/func.h>

#include <passport/infra/libs/cpp/auth_core/session.h>
#include <passport/infra/libs/cpp/auth_core/sessionparser.h>
#include <passport/infra/libs/cpp/dbpool/db_pool.h>

#include <util/generic/string.h>

#include <vector>

namespace NPassport::NLast {
    //
    // Time-handling helpers
    //
    time_t CalcTimeFromDelta(const TString& strdelta);
    time_t CalcTimeDiffFromDelta(const TString& strdelta, const TString& strbase);
    TString FormatTimeFromDelta(const TString& strdelta);

    // User section for v3 cookie
    struct TUserSection {
        TString Uid;
        TString PwdCheckTime;
        TString Flags;
        TString Lang;
        TString SocProfile;
        TString LoginTimeDiff;
        TString KvExt;

        TUserSection(const TString& uid);

    private:
        TUserSection() = default;
    };

    //
    // Helper classes to generate Session_id cookie and session_info CGI value
    //
    struct TSessionContext {
        TSessionContext(const TFunctionArgs&);
        ~TSessionContext() = default;

        int Version = 3;

        TString InvAge;
        TString Host;
        TString Ttl;

        TString Uid;

        TString AuthidTime, AuthidIp, AuthidId; // sid 8 cookie extension fields
        TString Dompref;
        TString Domsuff;
        TString Keynum;
        TString Rnd;
        TString Keybinbody;
        TString Keybodyhash;

        // v2 fields
        TString Safe;

        // v3 fields
        TString DefIdx;
        TString Flags;
        TString KvExt;
        std::vector<TUserSection> Users;

        bool UseGamma = true;

        long Age() const;

        static void SetupDomainKeys(NDbPool::TDbPool&, NAuth::TSessionSigner& sessSigner);

        static const char* StatusString(NAuth::TSession::EStatus s) {
            return (size_t)s < statusCount_ ? TSessionContext::statusStrings_[s] : "UNKNOWN";
        }

        TString ComposeSession(const TString& defaultAge = TString()) const;

    private:
        TSessionContext();

        struct TKeyData {
            TKeyData(const TString& id, const TString& body);

            TString Id;
            TString Binbody;
            TString Hash;
        };

        // map: keyspace name -> one key for that keyspace
        using TKeyMap = std::map<TString, TKeyData>;
        // map: keyspace name -> keyspace id
        using TKeyspaceIdMap = std::map<TString, TString>;
        static TSessionContext::TKeyMap::iterator HostToSuffix(const TString& host, TString& dompref);
        TString ComposeSessionV3(const TString& defaultAge) const;

        static const TSessionContext default_;

        // NOLINTNEXTLINE(cppcoreguidelines-avoid-non-const-global-variables)
        static TKeyMap domainKeys_;
        // NOLINTNEXTLINE(cppcoreguidelines-avoid-non-const-global-variables)
        static TKeyspaceIdMap domainIds_;

        static const char* const statusStrings_[];
        static const size_t statusCount_;
    };

    //
    // Session_id composer
    //
    class TIdComposer {
    public:
        TIdComposer(const TFunctionArgs& args)
            : Args_(args)
            , Context_(args)
        {
        }
        ~TIdComposer() = default;

        TString NoAuth() const;
        TString SignBroken() const;
        TString Disabled() const;
        TString Valid() const;
        TString NeedReset() const;
        TString Expired() const;
        TString NoCookie() const;
        static TString CantCheck();

    private:
        void Validate(const TString& value, NAuth::TSession::EStatus expected) const;

        const TFunctionArgs& Args_;
        TSessionContext Context_;
    };
}
